/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.util.Map;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class NotesConfigScreen {
    public static class_437 build(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Player Notes")).setSavingRunnable(PlayerNoteStorage::forceSave);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory notesCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"All Notes"));
        Map<String, String> notes = PlayerNoteStorage.getAllNotes();
        if (notes.isEmpty()) {
            notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"No notes found! Add some in-game first.")).build());
        } else {
            for (Map.Entry<String, String> entry : notes.entrySet()) {
                String player = entry.getKey();
                String note = entry.getValue();
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)class_2561.method_43470((String)player), note).setTooltip(new class_2561[]{class_2561.method_43470((String)("Edit note for " + player))}).setSaveConsumer(newValue -> PlayerNoteStorage.saveNote(player, newValue)).build());
                boolean isFav = PlayerNoteStorage.isFavourite(player);
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)("\u2605 Favourite: " + player)), isFav).setSaveConsumer(fav -> {
                    if (fav.booleanValue()) {
                        PlayerNoteStorage.addFavourite(player);
                    } else {
                        PlayerNoteStorage.removeFavourite(player);
                    }
                }).build());
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)("\ud83d\uddd1 Delete " + player + "'s Note")), false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Remove this note entirely")}).setSaveConsumer(shouldRemove -> {
                    if (shouldRemove.booleanValue()) {
                        PlayerNoteStorage.removeNote(player);
                    }
                }).build());
            }
        }
        ConfigCategory globalCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Options"));
        globalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Clear All Notes"), false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Deletes ALL notes and favourites. This cannot be undone!")}).setSaveConsumer(shouldClear -> {
            if (shouldClear.booleanValue()) {
                PlayerNoteStorage.clearAllNotes();
            }
        }).build());
        return builder.build();
    }
}

