/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.ntf.PlayerNoteStorage;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class NotesCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"notes").executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Usage: /notes help"));
            return 1;
        })).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Notes Commands:"));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/notes list - List all saved notes"));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/notes add <player> <note> - Add note for a player"));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/notes view <player> - View a player's note"));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/notes delete <player> - Delete a player's note"));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/notes help - Shows this help message"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            if (PlayerNoteStorage.getAllNotes().isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"No notes saved."));
            } else {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Saved Notes:"));
                PlayerNoteStorage.getAllNotes().forEach((player, note) -> ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("- " + player + ": " + note))));
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestOnlinePlayers).then(ClientCommandManager.argument((String)"note", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String note = StringArgumentType.getString((CommandContext)ctx, (String)"note");
            PlayerNoteStorage.saveNote(player, note);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Added note for " + player + ": " + note)));
            return 1;
        }))))).then(ClientCommandManager.literal((String)"view").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestSavedPlayers).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String note = PlayerNoteStorage.getNote(player);
            if (note == null || note.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("No note found for " + player)));
            } else {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(player + "'s note: " + note)));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestSavedPlayers).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            if (PlayerNoteStorage.hasNote(player)) {
                PlayerNoteStorage.removeNote(player);
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Deleted note for " + player)));
            } else {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("No note found for " + player)));
            }
            return 1;
        }))));
    }

    private static CompletableFuture<Suggestions> suggestOnlinePlayers(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        List online = class_310.method_1551().method_1562() != null ? class_310.method_1551().method_1562().method_2880().stream().map(class_640::method_2966).map(profile -> profile.name()).toList() : List.of();
        online.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestSavedPlayers(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        PlayerNoteStorage.getAllNotes().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

