/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.ntf.PinnedNoteManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PlayerNoteStorage
extends PinnedNoteManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"nts");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path NOTES_FILE = FabricLoader.getInstance().getConfigDir().resolve("ntf_player_notes.json");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm dd/MM/yyyy");
    private static Map<String, String> playerNotes = new HashMap<String, String>();
    private static Set<String> favouritePlayers = new HashSet<String>();
    private static Map<String, String> playerTags = new HashMap<String, String>();
    private static Map<String, List<TimestampedNote>> noteHistories = new HashMap<String, List<TimestampedNote>>();
    private static String selectedFilterTag = "All";

    public static void saveNote(String playerName, String note) {
        if (note == null || note.trim().isEmpty()) {
            playerNotes.remove(playerName);
        } else {
            playerNotes.put(playerName, note.trim());
            noteHistories.computeIfAbsent(playerName, k -> new ArrayList()).add(new TimestampedNote(note.trim()));
        }
        PlayerNoteStorage.saveNotes();
    }

    public static String getNote(String playerName) {
        return playerNotes.get(playerName);
    }

    public static boolean hasNote(String playerName) {
        return playerNotes.containsKey(playerName);
    }

    public static void removeNote(String playerName) {
        playerNotes.remove(playerName);
        favouritePlayers.remove(playerName);
        playerTags.remove(playerName);
        PlayerNoteStorage.unpin();
        PlayerNoteStorage.saveNotes();
    }

    public static void addFavourite(String playerName) {
        favouritePlayers.add(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static void removeFavourite(String playerName) {
        favouritePlayers.remove(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static boolean isFavourite(String playerName) {
        return favouritePlayers.contains(playerName);
    }

    public static void savePinnedPlayer(String player) {
        PlayerNoteStorage.saveNotes();
    }

    public static void setTag(String player, String tag) {
        if (tag == null || tag.isEmpty()) {
            playerTags.remove(player);
        } else {
            playerTags.put(player, tag);
        }
        PlayerNoteStorage.saveNotes();
    }

    public static String getTag(String player) {
        return playerTags.getOrDefault(player, "");
    }

    public static Map<String, String> getAllTags() {
        return new HashMap<String, String>(playerTags);
    }

    public static List<TimestampedNote> getNoteHistory(String player) {
        return noteHistories.getOrDefault(player, List.of());
    }

    public static void clearNoteHistory(String player) {
        noteHistories.remove(player);
        PlayerNoteStorage.saveNotes();
    }

    public static void clearAllNoteHistories() {
        noteHistories.clear();
        PlayerNoteStorage.saveNotes();
    }

    private static void loadNotes() {
        if (!Files.exists(NOTES_FILE, new LinkOption[0])) {
            LOGGER.info("Notes file not found, skipping load.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(NOTES_FILE);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            Type notesType = new TypeToken<Map<String, String>>(){}.getType();
            playerNotes = (Map)GSON.fromJson(json.get("notes"), notesType);
            if (playerNotes == null) {
                playerNotes = new HashMap<String, String>();
            }
            Type favType = new TypeToken<Set<String>>(){}.getType();
            favouritePlayers = (Set)GSON.fromJson(json.get("favourites"), favType);
            if (favouritePlayers == null) {
                favouritePlayers = new HashSet<String>();
            }
            Type tagType = new TypeToken<Map<String, String>>(){}.getType();
            playerTags = (Map)GSON.fromJson(json.get("tags"), tagType);
            if (playerTags == null) {
                playerTags = new HashMap<String, String>();
            }
            noteHistories.clear();
            JsonObject historiesJson = json.getAsJsonObject("histories");
            if (historiesJson != null) {
                for (String player : historiesJson.keySet()) {
                    ArrayList<TimestampedNote> list = new ArrayList<TimestampedNote>();
                    JsonElement arrElem = historiesJson.get(player);
                    if (arrElem.isJsonArray()) {
                        for (JsonElement elem : arrElem.getAsJsonArray()) {
                            if (elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString()) {
                                list.add(new TimestampedNote(elem.getAsString()));
                                continue;
                            }
                            if (!elem.isJsonObject()) continue;
                            TimestampedNote tsNote = (TimestampedNote)GSON.fromJson(elem, TimestampedNote.class);
                            if (tsNote.note == null) continue;
                            list.add(tsNote);
                        }
                    }
                    noteHistories.put(player, list);
                }
            }
            if (json.has("pinnedPlayer")) {
                PinnedNoteManager.loadPinnedState(json.get("pinnedPlayer").isJsonNull() ? null : json.get("pinnedPlayer").getAsString());
            }
            LOGGER.info("Successfully loaded notes, favourites, tags, histories, and pinned state!");
        }
        catch (IOException e) {
            LOGGER.error("Failed to load player notes: ", (Throwable)e);
        }
    }

    private static void saveNotes() {
        try {
            Files.createDirectories(NOTES_FILE.getParent(), new FileAttribute[0]);
            StorageData data = new StorageData();
            data.notes = playerNotes;
            data.favourites = favouritePlayers;
            data.tags = playerTags;
            data.histories = noteHistories;
            data.pinnedPlayer = PinnedNoteManager.getPinnedPlayer();
            try (BufferedWriter writer = Files.newBufferedWriter(NOTES_FILE, new OpenOption[0]);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save player notes: ", (Throwable)e);
        }
    }

    public static Map<String, String> getAllNotes() {
        return new HashMap<String, String>(playerNotes);
    }

    public static void clearAllNotes() {
        playerNotes.clear();
        favouritePlayers.clear();
        playerTags.clear();
        noteHistories.clear();
        PlayerNoteStorage.unpin();
        PlayerNoteStorage.saveNotes();
    }

    public static void forceSave() {
        PlayerNoteStorage.saveNotes();
    }

    public static String getSelectedFilterTag() {
        return selectedFilterTag;
    }

    public static void setSelectedFilterTag(String tag) {
        selectedFilterTag = tag;
        PlayerNoteStorage.forceSave();
    }

    static {
        PlayerNoteStorage.loadNotes();
    }

    @Environment(value=EnvType.CLIENT)
    public static class TimestampedNote {
        public String note;
        public String timestamp;

        public TimestampedNote() {
        }

        public TimestampedNote(String note) {
            this.note = note;
            this.timestamp = TIME_FORMAT.format(new Date());
        }

        public String toString() {
            return this.note;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class StorageData {
        Map<String, String> notes = new HashMap<String, String>();
        Set<String> favourites = new HashSet<String>();
        Map<String, String> tags = new HashMap<String, String>();
        Map<String, List<TimestampedNote>> histories = new HashMap<String, List<TimestampedNote>>();
        String pinnedPlayer = null;

        private StorageData() {
        }
    }
}

