/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.NotesHistoryScreen;
import com.ntf.PinnedNoteManager;
import com.ntf.PlayerNoteStorage;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_7923;
import net.minecraft.class_8685;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PlayerNotesScreen
extends class_437 {
    private static final int PLAYER_PANEL_WIDTH = 200;
    private static final int PLAYER_BUTTON_HEIGHT = 32;
    private static final int HEAD_SIZE = 24;
    private static final int SPACING = 4;
    private List<class_640> players;
    private List<class_640> displayedPlayers = new ArrayList<class_640>();
    private String selectedPlayer = null;
    private class_342 noteField;
    private class_342 searchField;
    private int scrollOffset = 0;
    private final int maxVisiblePlayers = 12;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"nts");
    private final List<class_4185> playerButtons = new ArrayList<class_4185>();
    private boolean showFavourites = false;
    private class_4185 pinButton;
    class_2960 saveNoteId = class_2960.method_60655((String)"ntf", (String)"save_note");
    class_3414 saveNoteSound = (class_3414)class_7923.field_41172.method_63535(this.saveNoteId);

    public PlayerNotesScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.ntf.player_notes"));
    }

    protected void method_25426() {
        super.method_25426();
        this.players = new ArrayList<class_640>();
        if (this.field_22787 != null && this.field_22787.method_1562() != null) {
            this.players.addAll(this.field_22787.method_1562().method_2880());
        }
        int centerX = 200 + (this.field_22789 - 200) / 2;
        this.searchField = new class_342(this.field_22793, 60, 35, 130, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchField.method_1863(text -> this.updatePlayerButtons());
        this.method_25429((class_364)this.searchField);
        this.noteField = new class_342(this.field_22793, centerX - 100, this.field_22790 / 2, 200, 20, (class_2561)class_2561.method_43473());
        this.noteField.method_1880(256);
        this.method_25429((class_364)this.noteField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.ntf.save_note"), button -> {
            if (this.selectedPlayer != null && !this.noteField.method_1882().isEmpty()) {
                PlayerNoteStorage.saveNote(this.selectedPlayer, this.noteField.method_1882());
                this.method_25419();
            }
        }).method_46434(centerX - 50, this.field_22790 / 2 + 40, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.ntf.clear_note"), button -> {
            if (this.selectedPlayer != null) {
                PlayerNoteStorage.removeNote(this.selectedPlayer);
                this.noteField.method_1852("");
            }
        }).method_46434(centerX - 50, this.field_22790 / 2 + 65, 100, 20).method_46431());
        this.pinButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udccc Pin Note"), button -> {
            if (this.selectedPlayer != null) {
                if (PinnedNoteManager.isPinned() && PinnedNoteManager.getPinnedPlayer().equals(this.selectedPlayer)) {
                    PinnedNoteManager.unpin();
                    if (this.field_22787 != null && this.field_22787.field_1705 != null) {
                        this.field_22787.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)("\u2716 Unpinned note for " + this.selectedPlayer)));
                        this.field_22787.field_1705.method_1743().method_1808(true);
                    }
                } else {
                    PlayerNoteStorage.saveNote(this.selectedPlayer, this.noteField.method_1882());
                    PinnedNoteManager.pin(this.selectedPlayer);
                    if (this.field_22787 != null && this.field_22787.field_1705 != null) {
                        String noteText = this.noteField.method_1882().isEmpty() ? "(no note)" : this.noteField.method_1882();
                        this.field_22787.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)("\ud83d\udccc Pinned note for " + this.selectedPlayer + ": " + noteText)));
                    }
                }
                this.updatePinButtonText();
            }
        }).method_46434(centerX - 50, this.field_22790 / 2 + 90, 100, 20).method_46431();
        this.method_37063((class_364)this.pinButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Show Favourites: OFF"), button -> {
            this.showFavourites = !this.showFavourites;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.showFavourites ? "Show Favourites: ON" : "Show Favourites: OFF")));
            this.scrollOffset = 0;
            this.updatePlayerButtons();
        }).method_46434(60, 10, 130, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcdc History"), button -> {
            if (this.selectedPlayer != null) {
                this.field_22787.method_1507((class_437)NotesHistoryScreen.buildHistoryScreen(this, this.selectedPlayer));
            }
        }).method_46434(centerX - 50, this.field_22790 / 2 + 115, 100, 20).method_46431());
        this.updatePlayerButtons();
    }

    private void updatePinButtonText() {
        if (this.selectedPlayer != null && PinnedNoteManager.isPinned() && PinnedNoteManager.getPinnedPlayer().equals(this.selectedPlayer)) {
            this.pinButton.method_25355((class_2561)class_2561.method_43470((String)"\ud83d\udccd Unpin Note"));
        } else {
            this.pinButton.method_25355((class_2561)class_2561.method_43470((String)"\ud83d\udccc Pin Note"));
        }
    }

    private void updatePlayerButtons() {
        for (class_4185 class_41852 : this.playerButtons) {
            this.method_37066((class_364)class_41852);
        }
        this.playerButtons.clear();
        this.displayedPlayers.clear();
        String query = this.searchField.method_1882().toLowerCase();
        for (class_640 p : this.players) {
            String name = p.method_2966().getName().toLowerCase();
            if (this.showFavourites && !PlayerNoteStorage.isFavourite(p.method_2966().getName()) || !query.isEmpty() && !name.contains(query)) continue;
            this.displayedPlayers.add(p);
        }
        int n = this.scrollOffset;
        int endIndex = Math.min(n + 12, this.displayedPlayers.size());
        if (this.displayedPlayers.size() > 12) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
                if (this.scrollOffset > 0) {
                    --this.scrollOffset;
                    this.updatePlayerButtons();
                }
            }).method_46434(175, 50, 20, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> {
                if (this.scrollOffset < this.displayedPlayers.size() - 12) {
                    ++this.scrollOffset;
                    this.updatePlayerButtons();
                }
            }).method_46434(175, this.field_22790 - 30, 20, 20).method_46431());
        }
        for (int i = n; i < endIndex; ++i) {
            class_640 player = this.displayedPlayers.get(i);
            String playerName = player.method_2966().getName();
            int yPos = 60 + (i - n) * 36;
            class_4185 playerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)playerName), button -> {
                this.selectedPlayer = playerName;
                String existingNote = PlayerNoteStorage.getNote(playerName);
                this.noteField.method_1852(existingNote != null ? existingNote : "");
                this.updatePinButtonText();
                this.method_25395((class_364)this.noteField);
            }).method_46434(30, yPos, 130, 32).method_46431();
            this.method_37063((class_364)playerButton);
            this.playerButtons.add(playerButton);
            boolean isFav = PlayerNoteStorage.isFavourite(playerName);
            class_4185 favButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(isFav ? "\u2605" : "\u2606")), button -> {
                if (PlayerNoteStorage.isFavourite(playerName)) {
                    PlayerNoteStorage.removeFavourite(playerName);
                    button.method_25355((class_2561)class_2561.method_43470((String)"\u2606"));
                } else {
                    PlayerNoteStorage.addFavourite(playerName);
                    button.method_25355((class_2561)class_2561.method_43470((String)"\u2605"));
                }
                if (this.showFavourites) {
                    this.updatePlayerButtons();
                }
            }).method_46434(165, yPos, 30, 32).method_46431();
            this.method_37063((class_364)favButton);
            this.playerButtons.add(favButton);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderCustomContent(context, mouseX, mouseY, delta);
        if (this.noteField != null) {
            this.noteField.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.searchField != null) {
            this.searchField.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private void renderCustomContent(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        context.method_25294(0, 0, 200, this.field_22790, Integer.MIN_VALUE);
        context.method_25294(200, 0, 202, this.field_22790, -10066330);
        int startIndex = this.scrollOffset;
        int endIndex = Math.min(startIndex + 12, this.displayedPlayers.size());
        for (int i = startIndex; i < endIndex; ++i) {
            class_640 player = this.displayedPlayers.get(i);
            int yPos = 60 + (i - startIndex) * 36;
            class_7532.method_52722((class_332)context, (class_8685)player.method_52810(), (int)4, (int)(yPos + 4), (int)24);
            if (!PlayerNoteStorage.hasNote(player.method_2966().getName())) continue;
            context.method_25294(190, yPos + 2, 198, yPos + 10, -10496);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"!"), 192, yPos + 2, -16777216);
        }
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Players").method_27692(class_124.field_1067), 10, 30, 0xFFFFFF);
        int centerX = 200 + (this.field_22789 - 200) / 2;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Player Notes"), centerX - this.field_22793.method_27525((class_5348)class_2561.method_43470((String)"Player Notes")) / 2, 30, -1);
        if (this.selectedPlayer != null) {
            class_5250 selectedText = class_2561.method_43470((String)("Selected: " + this.selectedPlayer)).method_27692(class_124.field_1054);
            context.method_27535(this.field_22793, (class_2561)selectedText, centerX - this.field_22793.method_27525((class_5348)selectedText) / 2, this.field_22790 / 2 - 40, -171);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.displayedPlayers.size() > 12) {
            int newOffset = this.scrollOffset - (int)Math.signum(verticalAmount);
            if ((newOffset = Math.max(0, Math.min(newOffset, this.displayedPlayers.size() - 12))) != this.scrollOffset) {
                this.scrollOffset = newOffset;
                this.updatePlayerButtons();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }
}

