/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class NotesConfigScreen {
    private static final String[] TAG_OPTIONS = new String[]{"All", "None", "Coordinates", "Description", "Important"};

    public static class_437 build(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Player Notes")).setSavingRunnable(PlayerNoteStorage::forceSave);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory notesCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"All Notes"));
        String currentFilter = PlayerNoteStorage.getSelectedFilterTag();
        notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu((class_2561)class_2561.method_43470((String)"Filter by Tag"), (Object)currentFilter, str -> str).setSelections(Arrays.asList(TAG_OPTIONS)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show only notes with the selected tag.")}).setSaveConsumer(PlayerNoteStorage::setSelectedFilterTag).build());
        Map<String, String> notes = PlayerNoteStorage.getAllNotes();
        Map<String, String> tags = PlayerNoteStorage.getAllTags();
        String selectedFilter = PlayerNoteStorage.getSelectedFilterTag();
        if (!selectedFilter.equals("All")) {
            notes = notes.entrySet().stream().filter(e -> tags.getOrDefault(e.getKey(), "None").equals(selectedFilter)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (notes.isEmpty()) {
            notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"No notes found! Add some in-game first.")).build());
        } else {
            for (Map.Entry<String, String> entry : notes.entrySet()) {
                String player = entry.getKey();
                String note = entry.getValue();
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)class_2561.method_43470((String)(player + " Note")), note).setTooltip(new class_2561[]{class_2561.method_43470((String)("Edit note for " + player))}).setSaveConsumer(newNote -> PlayerNoteStorage.saveNote(player, newNote)).build());
                boolean isFav = PlayerNoteStorage.isFavourite(player);
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)("\u2605 Favourite: " + player)), isFav).setSaveConsumer(fav -> {
                    if (fav.booleanValue()) {
                        PlayerNoteStorage.addFavourite(player);
                    } else {
                        PlayerNoteStorage.removeFavourite(player);
                    }
                }).build());
                String currentTag = PlayerNoteStorage.getTag(player);
                if (currentTag.isEmpty()) {
                    currentTag = "None";
                }
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDropdownMenu((class_2561)class_2561.method_43470((String)(player + " Tag")), (Object)currentTag, str -> str).setSelections(Arrays.asList(TAG_OPTIONS).subList(1, TAG_OPTIONS.length)).setDefaultValue((Object)"None").setTooltip(new class_2561[]{class_2561.method_43470((String)"Assign a tag to this note.")}).setSaveConsumer(tag -> PlayerNoteStorage.setTag(player, tag.equals("None") ? "" : tag)).build());
                notesCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)("\ud83d\uddd1 Delete " + player + "'s Note")), false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Remove this note entirely")}).setSaveConsumer(shouldRemove -> {
                    if (shouldRemove.booleanValue()) {
                        PlayerNoteStorage.removeNote(player);
                    }
                }).build());
            }
        }
        ConfigCategory globalCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Options"));
        globalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Clear All Notes"), false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Deletes ALL notes and favourites. This cannot be undone!")}).setSaveConsumer(shouldClear -> {
            if (shouldClear.booleanValue()) {
                PlayerNoteStorage.clearAllNotes();
            }
        }).build());
        return builder.build();
    }
}

