/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class NotesImportScreen
extends class_437 {
    private final class_437 parent;
    private final List<Path> importFiles = new ArrayList<Path>();
    private int scrollOffset = 0;
    private final int maxVisible = 6;

    public NotesImportScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Import Notes"));
        this.parent = parent;
    }

    protected void method_25426() {
        block12: {
            super.method_25426();
            this.importFiles.clear();
            Path importDir = FabricLoader.getInstance().getConfigDir().resolve("notes_import");
            try {
                if (Files.exists(importDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(importDir, "*.json");){
                        for (Path file : stream) {
                            this.importFiles.add(file);
                        }
                        break block12;
                    }
                }
                Files.createDirectories(importDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int centerX = this.field_22789 / 2;
        int yStart = 40;
        int spacing = 25;
        int endIndex = Math.min(this.scrollOffset + 6, this.importFiles.size());
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            Path file = this.importFiles.get(i);
            int y = yStart + (i - this.scrollOffset) * spacing;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)file.getFileName().toString()), button -> {
                PlayerNoteStorage.importNotes(file.getFileName().toString());
                this.field_22787.method_1507(this.parent);
            }).method_46434(centerX - 100, y, 200, 20).method_46431());
        }
        if (this.importFiles.size() > 6) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
                this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
                this.method_25426();
            }).method_46434(centerX + 110, yStart, 20, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> {
                this.scrollOffset = Math.min(this.scrollOffset + 1, this.importFiles.size() - 6);
                this.method_25426();
            }).method_46434(centerX + 110, yStart + 5 * spacing, 20, 20).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX - 50, this.field_22790 - 30, 100, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Import Notes").method_27692(class_124.field_1054), this.field_22789 / 2, 10, 0xFFFFFF);
    }

    public boolean method_25421() {
        return false;
    }
}

