/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.ntf.PinnedNoteManager;
import com.ntf.PlayerNoteStorage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;

@OnlyIn(value=Dist.CLIENT)
public class NotesCommand {
    private static final Path LAST_DAILY_FILE = FMLPaths.CONFIGDIR.get().resolve("ntf_last_daily.txt");

    public static void onRegisterCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"notes").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Usage: /notes help"));
            return 1;
        })).then(Commands.literal((String)"help").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Notes Commands:"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes list - List all saved notes"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes add <player> <note> - Add note for a player"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes view <player> - View a player's note"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes delete <player> - Delete a player's note"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes daily - Show a random note once per day"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes pin - Pins a note to the side of the screen"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes unpin - Removes a pinned note."));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"/notes help - Shows this help message"));
            return 1;
        }))).then(Commands.literal((String)"list").executes(ctx -> {
            if (PlayerNoteStorage.getAllNotes().isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"No notes saved."));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Saved Notes:"));
                PlayerNoteStorage.getAllNotes().forEach((player, note) -> ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("- " + player + ": " + note))));
            }
            return 1;
        }))).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestOnlinePlayers).then(Commands.argument((String)"note", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String note = StringArgumentType.getString((CommandContext)ctx, (String)"note");
            PlayerNoteStorage.saveNote(player, note);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Added note for " + player + ": " + note)));
            return 1;
        }))))).then(Commands.literal((String)"view").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestSavedPlayers).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String note = PlayerNoteStorage.getNote(player);
            if (note == null || note.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("No note found for " + player)));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)(player + "'s note: " + note)));
            }
            return 1;
        })))).then(Commands.literal((String)"delete").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestSavedPlayers).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            if (PlayerNoteStorage.hasNote(player)) {
                PlayerNoteStorage.removeNote(player);
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Deleted note for " + player)));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("No note found for " + player)));
            }
            return 1;
        })))).then(Commands.literal((String)"daily").executes(ctx -> NotesCommand.showDailyNote((CommandContext<CommandSourceStack>)ctx)))).then(Commands.literal((String)"pin").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(NotesCommand::suggestSavedPlayers).executes(ctx -> {
            String player = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String note = PlayerNoteStorage.getNote(player);
            if (note == null || note.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("No note found for " + player)));
            } else {
                PinnedNoteManager.pin(player);
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("\ud83d\udccc Pinned note for " + player)));
            }
            return 1;
        })))).then(Commands.literal((String)"unpin").executes(ctx -> {
            if (PlayerNoteStorage.getPinnedPlayer() != null) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("Unpinned note for " + PlayerNoteStorage.getPinnedPlayer())));
                PinnedNoteManager.pin(null);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"No note is currently pinned."));
            }
            return 1;
        })));
    }

    private static int showDailyNote(CommandContext<CommandSourceStack> ctx) {
        Map<String, String> notes;
        LocalDate today = LocalDate.now();
        if (Files.exists(LAST_DAILY_FILE, new LinkOption[0])) {
            try {
                String lastUsed = Files.readString(LAST_DAILY_FILE).trim();
                if (lastUsed.equals(today.toString())) {
                    ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"You've already viewed your daily note today! Come back tomorrow."));
                    return 1;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Error: Could not read last daily note file."));
                return 1;
            }
        }
        if ((notes = PlayerNoteStorage.getAllNotes()).isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"No saved notes to show."));
            return 1;
        }
        List<Map.Entry<String, String>> entries = List.copyOf(notes.entrySet());
        Map.Entry<String, String> randomEntry = entries.get(new Random().nextInt(entries.size()));
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("\ud83d\udcd3 Daily Note (" + randomEntry.getKey() + "): " + randomEntry.getValue())));
        try {
            Files.writeString(LAST_DAILY_FILE, (CharSequence)today.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestOnlinePlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List online = Minecraft.getInstance().getConnection() != null ? Minecraft.getInstance().getConnection().getOnlinePlayers().stream().map(PlayerInfo::getProfile).map(profile -> profile.getName()).toList() : List.of();
        online.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestSavedPlayers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerNoteStorage.getAllNotes().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

