/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;

public class NotesImportScreen
extends Screen {
    private final Screen parent;
    private final List<Path> importFiles = new ArrayList<Path>();
    private int scrollOffset = 0;
    private final int maxVisible = 6;

    public NotesImportScreen(Screen parent) {
        super((Component)Component.literal((String)"Import Notes"));
        this.parent = parent;
    }

    protected void init() {
        block12: {
            super.init();
            this.importFiles.clear();
            Path importDir = FMLPaths.CONFIGDIR.get().resolve("notes_import");
            try {
                if (Files.exists(importDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(importDir, "*.json");){
                        for (Path file : stream) {
                            this.importFiles.add(file);
                        }
                        break block12;
                    }
                }
                Files.createDirectories(importDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int centerX = this.width / 2;
        int yStart = 40;
        int spacing = 25;
        int endIndex = Math.min(this.scrollOffset + 6, this.importFiles.size());
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            Path file = this.importFiles.get(i);
            int y = yStart + (i - this.scrollOffset) * spacing;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)file.getFileName().toString()), button -> {
                PlayerNoteStorage.importNotes(file.getFileName().toString());
                this.minecraft.setScreen(this.parent);
            }).bounds(centerX - 100, y, 200, 20).build());
        }
        if (this.importFiles.size() > 6) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2191"), button -> {
                this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
                this.init();
            }).bounds(centerX + 110, yStart, 20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2193"), button -> {
                this.scrollOffset = Math.min(this.scrollOffset + 1, this.importFiles.size() - 6);
                this.init();
            }).bounds(centerX + 110, yStart + 5 * spacing, 20, 20).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX - 50, this.height - 30, 100, 20).build());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, (Component)Component.literal((String)"Import Notes").withStyle(ChatFormatting.YELLOW), this.width / 2, 10, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

