/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.NotesHistoryScreen;
import com.ntf.NotesImportScreen;
import com.ntf.PinnedNoteManager;
import com.ntf.PlayerNoteStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class PlayerNotesScreen
extends Screen {
    private static final int PLAYER_PANEL_WIDTH = 200;
    private static final int PLAYER_BUTTON_HEIGHT = 32;
    private static final int HEAD_SIZE = 24;
    private static final int SPACING = 4;
    private List<PlayerInfo> players;
    private List<PlayerInfo> displayedPlayers = new ArrayList<PlayerInfo>();
    private String selectedPlayer = null;
    private EditBox noteField;
    private EditBox searchField;
    private int scrollOffset = 0;
    private final int maxVisiblePlayers = 12;
    private final List<Button> playerButtons = new ArrayList<Button>();
    private boolean showFavourites = false;
    private Button pinButton;

    public PlayerNotesScreen() {
        super((Component)Component.translatable((String)"screen.ntf.player_notes"));
    }

    public static String getPlayerCoordinates() {
        if (Minecraft.getInstance().player != null) {
            LocalPlayer player = Minecraft.getInstance().player;
            int x = (int)player.getX();
            int y = (int)player.getY();
            int z = (int)player.getZ();
            return "X: " + x + " Y: " + y + " Z: " + z;
        }
        return "";
    }

    private String buildNoteTooltip(String playerName) {
        List<PlayerNoteStorage.TimestampedNote> history = PlayerNoteStorage.getNoteHistory(playerName);
        if (history.isEmpty()) {
            return "No notes yet";
        }
        PlayerNoteStorage.TimestampedNote latest = history.get(history.size() - 1);
        Object note = latest.note;
        if (((String)note).length() > 100) {
            note = ((String)note).substring(0, 100) + "...";
        }
        return "Last Note:\n" + (String)note + "\nSaved: " + latest.timestamp;
    }

    protected void init() {
        super.init();
        this.players = new ArrayList<PlayerInfo>();
        if (this.minecraft != null && this.minecraft.getConnection() != null) {
            this.players.addAll(this.minecraft.getConnection().getOnlinePlayers());
        }
        int centerX = 200 + (this.width - 200) / 2;
        this.searchField = new EditBox(this.font, 60, 35, 130, 20, (Component)Component.literal((String)"Search"));
        this.searchField.setResponder(text -> this.updatePlayerButtons());
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.noteField = new EditBox(this.font, centerX - 100, this.height / 2, 200, 20, (Component)Component.empty());
        this.noteField.setMaxLength(256);
        this.addRenderableWidget((GuiEventListener)this.noteField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.ntf.save_note"), button -> {
            if (this.selectedPlayer != null && !this.noteField.getValue().isEmpty()) {
                PlayerNoteStorage.saveNote(this.selectedPlayer, this.noteField.getValue());
                this.onClose();
            }
        }).bounds(centerX - 50, this.height / 2 + 40, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.ntf.clear_note"), button -> {
            if (this.selectedPlayer != null) {
                PlayerNoteStorage.removeNote(this.selectedPlayer);
                this.noteField.setValue("");
            }
        }).bounds(centerX - 50, this.height / 2 + 65, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"text.ntf.export_notes"), b -> {
            PlayerNoteStorage.exportNotes();
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"text.ntf.export_message"), false);
            }
        }).bounds(centerX + 60, this.height / 2 + 65, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"text.ntf.import_notes"), button -> this.minecraft.setScreen((Screen)new NotesImportScreen(this))).bounds(centerX + 60, this.height / 2 + 40, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"text.ntf.add_coordinates"), button -> {
            if (this.noteField != null) {
                String coords = PlayerNotesScreen.getPlayerCoordinates();
                String currentText = this.noteField.getValue();
                if (!currentText.isEmpty()) {
                    this.noteField.setValue(currentText + " | " + coords);
                } else {
                    this.noteField.setValue(coords);
                }
            }
        }).bounds(centerX + 60, this.height / 2 + 90, 80, 20).build());
        this.pinButton = Button.builder((Component)Component.translatable((String)"text.ntf.pin_note"), button -> {
            if (this.selectedPlayer != null) {
                if (PinnedNoteManager.isPinned() && PinnedNoteManager.getPinnedPlayer().equals(this.selectedPlayer)) {
                    PinnedNoteManager.unpin();
                    if (this.minecraft != null && this.minecraft.gui != null) {
                        this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)("text.ntf.pin_remove" + this.selectedPlayer)));
                    }
                } else {
                    PlayerNoteStorage.saveNote(this.selectedPlayer, this.noteField.getValue());
                    PinnedNoteManager.pin(this.selectedPlayer);
                    if (this.minecraft != null && this.minecraft.gui != null) {
                        String noteText = this.noteField.getValue().isEmpty() ? "(no note)" : this.noteField.getValue();
                        this.minecraft.gui.getChat().addMessage((Component)Component.literal((String)("Pinned note for: " + this.selectedPlayer + ": " + noteText)));
                    }
                }
                this.updatePinButtonText();
            }
        }).bounds(centerX - 50, this.height / 2 + 90, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.pinButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"text.ntf.favourite_off"), button -> {
            this.showFavourites = !this.showFavourites;
            button.setMessage((Component)Component.translatable((String)(this.showFavourites ? "text.ntf.favourite_on" : "text.ntf.favourite_off")));
            this.scrollOffset = 0;
            this.updatePlayerButtons();
        }).bounds(60, 10, 130, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"text.ntf.history"), button -> {
            if (this.selectedPlayer != null) {
                this.minecraft.setScreen((Screen)NotesHistoryScreen.buildHistoryScreen(this, this.selectedPlayer));
            }
        }).bounds(centerX - 50, this.height / 2 + 115, 100, 20).build());
        this.updatePlayerButtons();
    }

    private void updatePinButtonText() {
        if (this.selectedPlayer != null && PinnedNoteManager.isPinned() && PinnedNoteManager.getPinnedPlayer().equals(this.selectedPlayer)) {
            this.pinButton.setMessage((Component)Component.translatable((String)"text.ntf.unpin_note"));
        } else {
            this.pinButton.setMessage((Component)Component.translatable((String)"text.ntf.pin_note"));
        }
    }

    private void updatePlayerButtons() {
        for (Button button2 : this.playerButtons) {
            this.removeWidget((GuiEventListener)button2);
        }
        this.playerButtons.clear();
        this.displayedPlayers.clear();
        String query = this.searchField.getValue().toLowerCase();
        for (PlayerInfo p : this.players) {
            String name = p.getProfile().getName().toLowerCase();
            if (this.showFavourites && !PlayerNoteStorage.isFavourite(p.getProfile().getName()) || !query.isEmpty() && !name.contains(query)) continue;
            this.displayedPlayers.add(p);
        }
        int n = this.scrollOffset;
        int endIndex = Math.min(n + 12, this.displayedPlayers.size());
        if (this.displayedPlayers.size() > 12) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2191"), button -> {
                if (this.scrollOffset > 0) {
                    --this.scrollOffset;
                    this.updatePlayerButtons();
                }
            }).bounds(175, 50, 20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2193"), button -> {
                if (this.scrollOffset < this.displayedPlayers.size() - 12) {
                    ++this.scrollOffset;
                    this.updatePlayerButtons();
                }
            }).bounds(175, this.height - 30, 20, 20).build());
        }
        for (int i = n; i < endIndex; ++i) {
            PlayerInfo player = this.displayedPlayers.get(i);
            String playerName = player.getProfile().getName();
            int yPos = 60 + (i - n) * 36;
            Button playerButton = Button.builder((Component)Component.literal((String)playerName), button -> {
                this.selectedPlayer = playerName;
                String existingNote = PlayerNoteStorage.getNote(playerName);
                this.noteField.setValue(existingNote != null ? existingNote : "");
                this.updatePinButtonText();
                this.setFocused((GuiEventListener)this.noteField);
            }).bounds(30, yPos, 130, 32).tooltip(Tooltip.create((Component)Component.literal((String)this.buildNoteTooltip(playerName)))).build();
            this.addRenderableWidget((GuiEventListener)playerButton);
            this.playerButtons.add(playerButton);
            boolean isFav = PlayerNoteStorage.isFavourite(playerName);
            Button favButton = Button.builder((Component)Component.literal((String)(isFav ? "\u2605" : "\u2606")), button -> {
                if (PlayerNoteStorage.isFavourite(playerName)) {
                    PlayerNoteStorage.removeFavourite(playerName);
                    button.setMessage((Component)Component.literal((String)"\u2606"));
                } else {
                    PlayerNoteStorage.addFavourite(playerName);
                    button.setMessage((Component)Component.literal((String)"\u2605"));
                }
                if (this.showFavourites) {
                    this.updatePlayerButtons();
                }
            }).bounds(165, yPos, 30, 32).build();
            this.addRenderableWidget((GuiEventListener)favButton);
            this.playerButtons.add(favButton);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderCustomContent(context, mouseX, mouseY, delta);
        if (this.noteField != null) {
            this.noteField.render(context, mouseX, mouseY, delta);
        }
        if (this.searchField != null) {
            this.searchField.render(context, mouseX, mouseY, delta);
        }
    }

    private void renderCustomContent(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        context.fill(0, 0, 200, this.height, Integer.MIN_VALUE);
        context.fill(200, 0, 202, this.height, -10066330);
        int startIndex = this.scrollOffset;
        int endIndex = Math.min(startIndex + 12, this.displayedPlayers.size());
        for (int i = startIndex; i < endIndex; ++i) {
            PlayerInfo player = this.displayedPlayers.get(i);
            int yPos = 60 + (i - startIndex) * 36;
            PlayerFaceRenderer.draw((GuiGraphics)context, (PlayerSkin)player.getSkin(), (int)4, (int)(yPos + 4), (int)24);
            if (!PlayerNoteStorage.hasNote(player.getProfile().getName())) continue;
            context.fill(190, yPos + 2, 198, yPos + 10, -10496);
            context.drawString(this.font, (Component)Component.literal((String)"!"), 192, yPos + 2, -16777216);
        }
        context.drawString(this.font, (Component)Component.translatable((String)"text.ntf.players").withStyle(ChatFormatting.BOLD), 10, 30, 0xFFFFFF);
        int centerX = 200 + (this.width - 200) / 2;
        MutableComponent playerNotesText = Component.translatable((String)"text.ntf.player_notes");
        context.drawString(this.font, (Component)playerNotesText, centerX - this.font.width((FormattedText)playerNotesText) / 2, 30, -1);
        if (this.selectedPlayer != null) {
            MutableComponent selectedText = Component.literal((String)("Selected: " + this.selectedPlayer)).withStyle(ChatFormatting.YELLOW);
            context.drawString(this.font, (Component)selectedText, centerX - this.font.width((FormattedText)selectedText) / 2, this.height / 2 - 40, -171);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.displayedPlayers.size() > 12) {
            int newOffset = this.scrollOffset - (int)Math.signum(verticalAmount);
            if ((newOffset = Math.max(0, Math.min(newOffset, this.displayedPlayers.size() - 12))) != this.scrollOffset) {
                this.scrollOffset = newOffset;
                this.updatePlayerButtons();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

