/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.ntf.PlayerNoteStorage;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class NotesHistoryScreen
extends class_437 {
    private final class_437 parent;
    private final String player;
    private final List<PlayerNoteStorage.TimestampedNote> history;
    private int scrollOffset = 0;
    private final int maxVisible = 6;

    public NotesHistoryScreen(class_437 parent, String player, List<PlayerNoteStorage.TimestampedNote> history) {
        super((class_2561)class_2561.method_43470((String)("History: " + player)));
        this.parent = parent;
        this.player = player;
        this.history = history;
    }

    public static NotesHistoryScreen buildHistoryScreen(class_437 parent, String player) {
        List<PlayerNoteStorage.TimestampedNote> playerHistory = PlayerNoteStorage.getNoteHistory(player);
        return new NotesHistoryScreen(parent, player, playerHistory);
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).method_46434(centerX - 180, this.field_22790 - 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear History"), button -> {
            PlayerNoteStorage.clearNoteHistory(this.player);
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).method_46434(centerX - 60, this.field_22790 - 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear All Histories"), button -> {
            PlayerNoteStorage.clearAllNoteHistories();
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).method_46434(centerX + 60, this.field_22790 - 30, 150, 20).method_46431());
        int yStart = 40;
        int spacing = 30;
        int endIndex = Math.min(this.scrollOffset + 6, this.history.size());
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            PlayerNoteStorage.TimestampedNote tsNote = this.history.get(i);
            int displayIndex = i + 1;
            String displayText = displayIndex + ". [" + tsNote.timestamp + "] " + (String)(tsNote.note.length() > 25 ? tsNote.note.substring(0, 25) + "..." : tsNote.note);
            int y = yStart + (i - this.scrollOffset) * spacing;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)displayText), button -> {
                PlayerNoteStorage.saveNote(this.player, tsNote.note);
                assert (this.field_22787 != null);
                this.field_22787.method_1507(this.parent);
            }).method_46434(centerX - 100, y, 200, 20).method_46431());
        }
        if (this.history.size() > 6) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> {
                this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
                this.method_25426();
            }).method_46434(centerX + 110, yStart, 20, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> {
                this.scrollOffset = Math.min(this.scrollOffset + 1, this.history.size() - 6);
                this.method_25426();
            }).method_46434(centerX + 110, yStart + 5 * spacing, 20, 20).method_46431());
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("History of " + this.player)).method_27692(class_124.field_1054), this.field_22789 / 2, 10, 0xFFFFFF);
    }

    public boolean method_25421() {
        return false;
    }
}

