/*
 * Decompiled with CFR 0.152.
 */
package com.ntf;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class PlayerNoteStorage {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path NOTES_FILE = FabricLoader.getInstance().getConfigDir().resolve("ntf_player_notes.json");
    private static Map<String, String> playerNotes = new HashMap<String, String>();
    private static Set<String> favouritePlayers = new HashSet<String>();

    public static void saveNote(String playerName, String note) {
        if (note == null || note.trim().isEmpty()) {
            playerNotes.remove(playerName);
        } else {
            playerNotes.put(playerName, note.trim());
        }
        PlayerNoteStorage.saveNotes();
    }

    public static String getNote(String playerName) {
        return playerNotes.get(playerName);
    }

    public static boolean hasNote(String playerName) {
        return playerNotes.containsKey(playerName);
    }

    public static void removeNote(String playerName) {
        playerNotes.remove(playerName);
        favouritePlayers.remove(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static void addFavourite(String playerName) {
        favouritePlayers.add(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static void removeFavourite(String playerName) {
        favouritePlayers.remove(playerName);
        PlayerNoteStorage.saveNotes();
    }

    public static boolean isFavourite(String playerName) {
        return favouritePlayers.contains(playerName);
    }

    public static Set<String> getFavourites() {
        return new HashSet<String>(favouritePlayers);
    }

    private static void loadNotes() {
        try {
            Type type;
            String json;
            Map data;
            if (Files.exists(NOTES_FILE, new LinkOption[0]) && (data = (Map)GSON.fromJson(json = Files.readString(NOTES_FILE), type = new TypeToken<Map<String, Object>>(){}.getType())) != null) {
                Object favObj;
                Object notesObj = data.get("notes");
                if (notesObj != null) {
                    String notesJson = GSON.toJson(notesObj);
                    Type notesType = new TypeToken<Map<String, String>>(){}.getType();
                    playerNotes = (Map)GSON.fromJson(notesJson, notesType);
                }
                if ((favObj = data.get("favourites")) != null) {
                    String favJson = GSON.toJson(favObj);
                    Type favType = new TypeToken<Set<String>>(){}.getType();
                    favouritePlayers = (Set)GSON.fromJson(favJson, favType);
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load player notes: " + e.getMessage());
        }
    }

    private static void saveNotes() {
        try {
            Files.createDirectories(NOTES_FILE.getParent(), new FileAttribute[0]);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("notes", playerNotes);
            data.put("favourites", favouritePlayers);
            String json = GSON.toJson(data);
            Files.writeString(NOTES_FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save player notes: " + e.getMessage());
        }
    }

    static {
        PlayerNoteStorage.loadNotes();
    }
}

