/*
 * Decompiled with CFR 0.152.
 */
package com.mrpgc_skilltree;

import com.mrpgc_skilltree.effect.MrpgSkillEffects;
import com.mrpgc_skilltree.skills.MrpgSkillDefinitions;
import com.mrpgc_skilltree.skills.MrpgSkillSounds;
import com.mrpgc_skilltree.skills.MrpgSkillSpells;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.puffish.skillsmod.reward.builtin.AttributeReward;
import net.skill_tree_rpgs.data_gen.SkillDefinitionGenerator;
import net.skill_tree_rpgs.node.SpellContainerReward;
import net.skill_tree_rpgs.utils.ResolvableTextContent;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.client.gui.SpellTooltip;

public class MRPGCSkillTreeAddOnDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(LangGenerator::new);
        pack.addProvider(SpellsGen::new);
        pack.addProvider(SkillDefinitionGen::new);
        pack.addProvider(SoundGen::new);
    }

    public static class SkillDefinitionGen
    extends SkillDefinitionGenerator {
        public SkillDefinitionGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generate(SkillDefinitionGenerator.Builder builder) {
            LinkedHashMap<String, SkillDefinitionGenerator.Format> skillDefinitions = new LinkedHashMap<String, SkillDefinitionGenerator.Format>();
            for (MrpgSkillDefinitions.Entry skill : MrpgSkillDefinitions.ENTRIES) {
                SkillDefinitionGenerator.Translatable title = null;
                if (skill.title() != null && !skill.title().isEmpty()) {
                    title = new SkillDefinitionGenerator.Translatable(skill.titleTranslationKey());
                }
                class_5250 description = skill.description() != null && !skill.description().isEmpty() ? class_2561.method_43471((String)skill.descriptionTranslationKey()) : class_5250.method_43477((class_7417)new ResolvableTextContent(skill.id()));
                SkillDefinitionGenerator.Icon icon = null;
                switch (skill.icon().type()) {
                    case TEXTURE: {
                        icon = SkillDefinitionGenerator.Icon.texture((String)skill.icon().value());
                        break;
                    }
                    case ITEM: {
                        icon = SkillDefinitionGenerator.Icon.item((String)skill.icon().value());
                        break;
                    }
                    case EFFECT: {
                        icon = SkillDefinitionGenerator.Icon.effect((String)skill.icon().value());
                    }
                }
                ArrayList<SkillDefinitionGenerator.Reward> rewards = new ArrayList<SkillDefinitionGenerator.Reward>();
                if (skill.attributeReward() != null) {
                    MrpgSkillDefinitions.EntityAttributeReward attribute = skill.attributeReward();
                    rewards.add(new SkillDefinitionGenerator.Reward(AttributeReward.ID.toString(), (Object)SkillDefinitionGenerator.RewardAttribute.from(attribute.attribute(), (class_1322)attribute.modifier())));
                }
                if (skill.spellReward() != null) {
                    rewards.add(new SkillDefinitionGenerator.Reward(SpellContainerReward.ID.toString(), (Object)new SpellContainerReward.DataStructure(skill.spellReward())));
                }
                SkillDefinitionGenerator.Format format = new SkillDefinitionGenerator.Format(title, (class_2561)description, icon, rewards);
                skillDefinitions.put(skill.id(), format);
            }
            builder.entries.add(new SkillDefinitionGenerator.Entry(MrpgSkillDefinitions.CATEGORY_ID, skillDefinitions));
        }
    }

    public static class SpellsGen
    extends SpellGenerator {
        public SpellsGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (MrpgSkillSpells.Entry entry : MrpgSkillSpells.all) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("mrpgc_skill_tree", MrpgSkillSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().method_12832(), (int)entry.variants())).toList()));
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            for (MrpgSkillDefinitions.Entry skill : MrpgSkillDefinitions.ENTRIES) {
                if (skill.title() != null && !skill.title().isEmpty()) {
                    translationBuilder.add(skill.titleTranslationKey(), skill.title());
                }
                if (skill.description() == null || skill.description().isEmpty()) continue;
                translationBuilder.add(skill.descriptionTranslationKey(), skill.description());
            }
            for (MrpgSkillSpells.Entry entry2 : MrpgSkillSpells.all) {
                translationBuilder.add(SpellTooltip.spellTranslationKey((class_2960)entry2.id()), entry2.title());
                translationBuilder.add(SpellTooltip.spellDescriptionTranslationKey((class_2960)entry2.id()), entry2.description());
            }
            MrpgSkillEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.method_5567(), entry.title);
                translationBuilder.add(entry.effect.method_5567() + ".description", entry.description);
            });
        }
    }
}

