package dev.blueon.quickleafdecay;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static dev.blueon.quickleafdecay.QuickLeafDecay.DECAYS_SLOWLY;
import static dev.blueon.quickleafdecay.Util.isModLoaded;

import dev.blueon.quickleafdecay.Config;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_6862;

public final class FeatureControl {

	public static boolean shouldMatchLeavesTypes() {
		return Config.matchLeavesTypes;
	}

	public static boolean shouldUnknownLeavesOnlyMatchSelf() {
		return Config.unknownLeavesOnlyMatchSelf;
	}

	public static boolean shouldMatchLogsToLeaves() {
		return Config.matchLogsToLeaves;
	}

	public static PersistentLeavesBehavior getPersistentLeavesBehavior() {
		return Config.persistentLeavesBehavior;
	}

	public static boolean shouldAccelerateLeavesDecay(class_2680 state) {
        return !state.method_26164(DECAYS_SLOWLY) && (
            Config.accelerateLeavesDecay
        );
    }

	public static int getDecayDelay(class_5819 random) {
		final int minDecayDelay;
		final int maxDecayDelay;

		minDecayDelay = Config.minDecayDelay;
		maxDecayDelay = Config.maxDecayDelay;

		return minDecayDelay < maxDecayDelay ?
			random.method_43051(minDecayDelay, maxDecayDelay + 1) : maxDecayDelay;
	}

	public static boolean shouldUpdateDiagonalLeaves() {
		return Config.updateDiagonalLeaves;
	}

	public static boolean shouldDoDecayingLeavesEffects() {
		return Config.doDecayingLeavesEffects;
	}

	public static boolean isMatchingLeaves(class_6862<class_2248> leavesTag, @NotNull class_2680 state, @NotNull class_2680 currentLeavesState) {
		if (state.method_26204() == currentLeavesState.method_26204()) return true;
		else if (leavesTag == null) return !shouldUnknownLeavesOnlyMatchSelf();
		else return state.method_26164(leavesTag);
	}

	public static boolean leavesMatch(@NotNull class_2680 leaves1, @NotNull class_2680 leaves2) {
        if (leaves1.method_26204() == leaves2.method_26204()) {
            return true;
        } else {
            @Nullable
            final class_6862<class_2248> leavesGroup = QuickLeafDecay.getLeavesGroup(leaves1.method_26204());
            if (leavesGroup == null) {
                return !shouldUnknownLeavesOnlyMatchSelf();
            } else {
                return leaves2.method_26164(leavesGroup);
            }
        }
    }

	public static void init() {
		Config.load();
		Config.save();
	}

	private FeatureControl() {
	}

	public enum PersistentLeavesBehavior {
        IGNORE,
        NORMAL,
        MATCH_ALL
    }
}
