package dev.blueon.quickleafdecay;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class QuickLeafDecay {
	public static final String NAMESPACE = "quickleafdecay";
	public static final class_2561 NAME = class_2561.method_43471("text." + NAMESPACE + ".name");

	public static final Logger LOGGER = LoggerFactory.getLogger(QuickLeafDecay.class);

	public static final class_6862<class_2248> LOGS_WITHOUT_LEAVES =
		class_6862.method_40092(class_7924.field_41254, idOf("logs_without_leaves"));
	public static final class_6862<class_2248> DECAYS_SLOWLY =
		class_6862.method_40092(class_7924.field_41254, idOf("decays_slowly"));

	private static final String LEAVES_GROUPS_SUB_PATH = "leaves_groups/";
	private static final String TREE_TYPES_SUB_PATH = "tree_types/";

	private static final Map<class_2248, class_6862<class_2248>> LEAVES_GROUPS = new HashMap<>();
	private static final Map<class_2248, class_6862<class_2248>> TREE_TYPES = new HashMap<>();

	public static void updateLeavesGroups(class_2248 leavesBlock) {
		updateBlockTag(leavesBlock, LEAVES_GROUPS, LEAVES_GROUPS_SUB_PATH);
	}

	public static void updateTreeTypes(class_2680 state) {
		if (state.method_26164(class_3481.field_15475)) {
			updateBlockTag(state.method_26204(), TREE_TYPES, TREE_TYPES_SUB_PATH);
		}
	}

	@Nullable
	public static class_6862<class_2248> getLeavesGroup(class_2248 leavesBlock) {
		return LEAVES_GROUPS.get(leavesBlock);
	}

	@Nullable
	public static class_6862<class_2248> getTreeType(class_2248 block) {
		return TREE_TYPES.get(block);
	}

	public static void clearTags() {
		LEAVES_GROUPS.clear();
		TREE_TYPES.clear();
	}

	private static void updateBlockTag(class_2248 block, Map<class_2248, class_6862<class_2248>> tagMap, String subPath) {
		if (tagMap.get(block) == null) {
			final class_2960 id = class_7923.field_41175.method_10221(block);
			tagMap.put(block, class_6862.method_40092(class_7924.field_41254, id.method_45138(subPath)));
		}
	}

	public static class_2960 idOf(String path) {
		return class_2960.method_60655(NAMESPACE, path);
	}

	public interface PackIds {
		class_2960 WOOD_PREVENTS_DECAY = idOf("wood_prevents_decay");
		class_2960 YUNGS_BETTER_MINESHAFTS_COMPAT = idOf("yungs_better_mineshafts_compat");
	}
}

