package dev.blueon.quickleafdecay;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_2561;
import java.util.Optional;

import static dev.blueon.quickleafdecay.QuickLeafDecay.LOGGER;

public final class Util {
    public static class_2561 replace(class_2561 text, String regex, String replacement) {
        String string = text.getString();
        string = string.replaceAll(regex, replacement);
        return class_2561.method_43470(string).method_10862(text.method_10866());
    }

    public static boolean isModLoaded(String id, String versionPredicate) {
        final Optional<ModContainer> optModContainer = FabricLoader.getInstance().getModContainer(id);
        if (optModContainer.isPresent()){
            try {
                return VersionPredicate.parse(versionPredicate).test(optModContainer.get().getMetadata().getVersion());
            } catch (VersionParsingException e) {
                LOGGER.error("Failed to parse version", e);
            }
        }

        return false;
    }

    private Util() { }
}
