package dev.blueon.quickleafdecay.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.blueon.quickleafdecay.FeatureControl.PersistentLeavesBehavior;
import dev.blueon.quickleafdecay.QuickLeafDecay;
import dev.blueon.quickleafdecay.mixin_helper.AbstractLeavesBlockMixinAccessor;
import dev.blueon.quickleafdecay.mixin_helper.ServerWorldMixinAccessor;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.class_10225;
import net.minecraft.class_10717;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

import static dev.blueon.quickleafdecay.FeatureControl.getDecayDelay;
import static dev.blueon.quickleafdecay.FeatureControl.leavesMatch;
import static dev.blueon.quickleafdecay.FeatureControl.shouldAccelerateLeavesDecay;
import static dev.blueon.quickleafdecay.FeatureControl.shouldDoDecayingLeavesEffects;
import static dev.blueon.quickleafdecay.FeatureControl.getPersistentLeavesBehavior;
import static dev.blueon.quickleafdecay.FeatureControl.shouldMatchLeavesTypes;
import static dev.blueon.quickleafdecay.FeatureControl.shouldMatchLogsToLeaves;
import static dev.blueon.quickleafdecay.FeatureControl.shouldUpdateDiagonalLeaves;
import static dev.blueon.quickleafdecay.QuickLeafDecay.LOGS_WITHOUT_LEAVES;

@Mixin(class_2397.class)
abstract class AbstractLeavesBlockMixin extends class_2248 implements AbstractLeavesBlockMixinAccessor {
	@Unique
	@NotNull
	private static final ThreadLocal<Optional<class_2680>> currentLeaves =
		ThreadLocal.withInitial(Optional::empty);

	@Shadow
	@Final
	public static class_2746 PERSISTENT;

	@Shadow
	protected abstract boolean shouldDecay(class_2680 state);

	private AbstractLeavesBlockMixin() {
        //noinspection DataFlowIssue
        super(null);
		throw new IllegalStateException("Dummy constructor called!");
	}

	@Override
	public void quickleafdecay$tryDecaying(
		class_3218 world, class_2338 pos, class_2680 state, class_5819 random
	) {
		if (shouldAccelerateLeavesDecay(state) && this.shouldDecay(state)) {
			method_9497(state, world, pos);
			world.method_8650(pos, false);
			this.trySpawningDecayEffects(state, world, pos);

			if (shouldUpdateDiagonalLeaves()) {
				getDiagonalPositions(pos).forEach(diagonalPos -> {
					final class_2680 diagonalState = world.method_8320(diagonalPos);
					if (
						diagonalState != null &&
						diagonalState.method_26204() instanceof class_10717 diagonalLeaves &&
						leavesMatch(diagonalState, this.method_9564())
					) {
						world.method_64310(diagonalPos, diagonalLeaves, 0);
					}
				});
			}
		}
	}

	@Inject(method = "getStateForNeighborUpdate",at = @At(value = "HEAD"))
	private void captureNeighborBlock(
		class_2680 state, class_4538 world, class_10225 tickSchedulerAccess, class_2338 pos, class_2350 direction,
		class_2338 neighborPos, class_2680 neighborState, class_5819 random,
		CallbackInfoReturnable<class_2680> cir
	) {
		if (shouldMatchLeavesTypes()) {
            QuickLeafDecay.updateLeavesGroups(this);
        }

		currentLeaves.set(Optional.of(state));
	}

	@Inject(method = "getStateForNeighborUpdate",at = @At(value = "TAIL"))
	private void resetCapturedNeighborBlock(CallbackInfoReturnable<class_2680> cir) {
		currentLeaves.remove();
	}

	@WrapMethod(method = "updateDistanceFromLogs")
	private static class_2680 captureUpdatingBlock(
		class_2680 state, class_1936 world, class_2338 pos,
		Operation<class_2680> original
	) {
		if (shouldMatchLeavesTypes()) {
			QuickLeafDecay.updateLeavesGroups(state.method_26204());
		}

		currentLeaves.set(Optional.of(state));

		final class_2680 newState = original.call(state, world, pos);

		currentLeaves.remove();

		return newState;
	}

	@ModifyArg(
		method = "updateDistanceFromLogs",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/block/LeavesBlock;getDistanceFromLog(Lnet/minecraft/block/BlockState;)I"
		)
	)
	private static class_2680 checkBlockState(class_2680 state) {
		if (shouldMatchLogsToLeaves()) {
			QuickLeafDecay.updateTreeTypes(state);
		}

		return state;
	}

	// If a tree tag is found, match it. Otherwise, match all logs like vanilla
	@Redirect(
		method = "getOptionalDistanceFromLog",
		at = @At(
			value = "INVOKE", ordinal = 0,
			target = "Lnet/minecraft/block/BlockState;isIn(Lnet/minecraft/registry/tag/TagKey;)Z"
		),
		slice = @Slice(
			from = @At(
				value = "FIELD",
				target = "Lnet/minecraft/registry/tag/BlockTags;LOGS:Lnet/minecraft/registry/tag/TagKey;"
			)
		)
	)
	private static boolean tryMatchLog(class_2680 state, class_6862<class_2248> tagKey) {
		if (shouldMatchLogsToLeaves()) {
			@Nullable
			final class_2680 leaves = currentLeaves.get().orElse(null);
			if (
				getPersistentLeavesBehavior() != PersistentLeavesBehavior.MATCH_ALL
					|| leaves == null
					|| !leaves.method_11654(PERSISTENT)
			) {
				if (state.method_26164(LOGS_WITHOUT_LEAVES)) {
					return false;
				}

				if (leaves != null) {
					final class_2248 block = state.method_26204();
					final class_6862<class_2248> treeType = QuickLeafDecay.getTreeType(block);
					if (
						treeType != null &&
							class_7923.field_41175.method_46733(treeType).isPresent()
					) {
						return leaves.method_26164(treeType);
					}
				}
			}
		}

		return state.method_26164(class_3481.field_15475);
	}

	@WrapOperation(
		method = "getOptionalDistanceFromLog",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/block/BlockState;contains(Lnet/minecraft/state/property/Property;)Z"
		)
	)
	private static boolean matchLeaves(
		class_2680 otherLeavesState, class_2769<?> property, Operation<Boolean> original
	) {
		if (
			!original.call(otherLeavesState, property) ||
			currentLeaves.get().isEmpty()
		) {
			return false;
		}

		final class_2680 currentLeavesState = currentLeaves.get().get();

		final PersistentLeavesBehavior persistentBehavior = getPersistentLeavesBehavior();
		if (persistentBehavior != PersistentLeavesBehavior.NORMAL) {
			final Boolean currentPersistent = currentLeavesState.method_11654(PERSISTENT);
			final Boolean otherPersistent = otherLeavesState.method_28500(PERSISTENT).orElse(false);
			// non-persistent leaves only care about other non-persistent leaves,
			//   persistent leaves care about BOTH non/persistent leaves
			if (
				persistentBehavior == PersistentLeavesBehavior.IGNORE &&
					(!currentPersistent && otherPersistent)
			) {
				return false;
			} else if (
				persistentBehavior == PersistentLeavesBehavior.MATCH_ALL &&
					(currentPersistent || otherPersistent)
			) {
				return true;
			}
		}

		if (shouldMatchLeavesTypes()) {
            return leavesMatch(otherLeavesState, currentLeavesState);
		}

		return true;
	}

    @WrapOperation(
		method = "scheduledTick",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/server/world/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;" +
				"Lnet/minecraft/block/BlockState;I)Z"
		)
	)
	private boolean tryAcceleratingDecay(
		class_3218 world, class_2338 pos, class_2680 newState, int flags, Operation<Boolean> original,
		class_2680 oldState, class_3218 duplicate1, class_2338 duplicate2, class_5819 random
	) {
		final boolean originalReturn = original.call(world, pos, newState, flags);

		// checking that the old state cannot decay is important for trees that generate with
		// leaves with incorrect distances
		if (this.shouldDecay(newState) && !this.shouldDecay(oldState)) {
			((ServerWorldMixinAccessor) world).quickleafdecay$scheduleLeavesDecayTick(
				pos, (class_2397)(Object) this, getDecayDelay(random)
			);
		}

		return originalReturn;
	}

	@Inject(
		method = "randomTick",
		at = @At(
			value = "INVOKE", shift = At.Shift.AFTER,
			target = "Lnet/minecraft/server/world/ServerWorld;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z"
		)
	)
	private void trySpawningDecayEffects(
		class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci
	) {
		this.trySpawningDecayEffects(state, world, pos);
	}

	@Unique
	private static Collection<class_2338> getDiagonalPositions(class_2338 pos) {
		final Collection<class_2338> diagonalPositions = new LinkedList<>();
		for (final class_2350 direction : class_2350.values()) {
			if (direction.method_10161() >= 0) {
				diagonalPositions.add(pos.method_10093(direction).method_10093(direction.method_10170()));
			} else {
				final class_2338 vOffsetPos = pos.method_10093(direction);
				class_2350.class_2353.field_11062.method_29716().forEach(horizontal ->
					diagonalPositions.add(vOffsetPos.method_10093(direction).method_10093(horizontal.method_10170()))
				);
			}
		}

		return diagonalPositions;
	}

	@Unique
	private void trySpawningDecayEffects(class_2680 state, class_3218 world, class_2338 pos) {
		if (shouldDoDecayingLeavesEffects()) {
			this.method_33614(world, null, pos, state);
		}
	}
}
