package dev.blueon.quickleafdecay.mixin;

import dev.blueon.quickleafdecay.QuickLeafDecay;
import dev.blueon.quickleafdecay.mixin_helper.PackedTicksMixinAccessor;
import dev.blueon.quickleafdecay.mixin_helper.WorldChunkMixinAccessor;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_11897;
import net.minecraft.class_1923;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2852;
import net.minecraft.class_5539;
import net.minecraft.class_6755;
import net.minecraft.class_6759;
import net.minecraft.class_7923;

@Mixin(class_2852.class)
abstract class ChunkSerializerMixin {
    @Shadow @Final private class_2791.class_6745 packedTicks;
    @Unique
    private static final String LEAVES_DECAY_SCHEDULER_KEY = QuickLeafDecay.NAMESPACE + ":leaves_decay_ticks";

    @Unique
    private static final Codec<class_2397> LEAVES_CODEC = class_7923.field_41175.method_39673().flatXmap(
        block -> {
            if (block instanceof class_2397 leavesBlock) {
                return DataResult.success(leavesBlock);
            } else {
                return DataResult.error(() -> "non-leaves block: " + class_7923.field_41175.method_10221(block));
            }
        },
        DataResult::success
    );

    @Unique
    private static final Codec<List<class_6759<class_2397>>> LEAVES_TICK_CODEC =
        class_6759.method_67719(LEAVES_CODEC).listOf();

    @ModifyExpressionValue(
        method = "fromNbt",
        at = @At(
            value = "NEW",
            target = "Lnet/minecraft/world/chunk/Chunk$TickSchedulers;"
        )
    )
    private static class_2791.class_6745 deserializeAndPackLeavesDecayTicks(
        class_2791.class_6745 originalPackedTicks,
        class_5539 world, class_11897 palettesFactory, class_2487 nbt,
        @Local class_1923 chunkPos
    ) {
        ((PackedTicksMixinAccessor) (Object) originalPackedTicks)
            .quickleafdecay$setLeavesDecayTicks(
                nbt.method_67491(LEAVES_DECAY_SCHEDULER_KEY, LEAVES_TICK_CODEC).orElse(List.of())
            );

        return originalPackedTicks;
    }

    @ModifyExpressionValue(
        method = "convert",
        at = @At(
            value = "NEW",
            target = "Lnet/minecraft/world/chunk/WorldChunk;"
        )
    )
    private class_2818 unpackTicksAndSetLeavesDecayScheduler(class_2818 original) {
        ((WorldChunkMixinAccessor) original).quickleafdecay$setLeavesDecayTickScheduler(
            new class_6755<>(
                ((PackedTicksMixinAccessor) (Object) this.packedTicks).quickleafdecay$getLeavesDecayTicks()
            )
        );

        return original;
    }

    @Inject(
        method = "serializeTicks",
        at = @At("TAIL")
    )
    private static void unpackAndSerializeLeavesDecayTicks(class_2487 nbt, class_2791.class_6745 packedTicks, CallbackInfo ci){
        final List<class_6759<class_2397>> leavesDecayTicks =
            ((PackedTicksMixinAccessor) (Object) packedTicks).quickleafdecay$getLeavesDecayTicks();
        // empty for non-WorldChunk Chunks
        if (!leavesDecayTicks.isEmpty()) {
            nbt.method_67494(LEAVES_DECAY_SCHEDULER_KEY, LEAVES_TICK_CODEC, leavesDecayTicks);
        }
    }
}
