package dev.blueon.quickleafdecay.mixin;

import dev.blueon.quickleafdecay.QuickLeafDecay;
import dev.blueon.quickleafdecay.mixin_helper.AbstractLeavesBlockMixinAccessor;
import dev.blueon.quickleafdecay.mixin_helper.ServerWorldMixinAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_5281;
import net.minecraft.class_6757;
import net.minecraft.class_6760;
import com.llamalad7.mixinextras.sugar.Local;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3218.class)
abstract class ServerWorldMixin extends class_1937 implements class_5281, ServerWorldMixinAccessor {
    @Unique
    private static final String LEAVES_DECAY_TICKS_PROFILER_LOCATION = QuickLeafDecay.NAMESPACE + ":leavesDecayTicks";

    private ServerWorldMixin() {
        //noinspection DataFlowIssue
        super(null, null, null, null, false, false, 0, 0);
        throw new IllegalStateException("Dummy constructor called!");
    }

    @Shadow
    public abstract boolean isChunkLoaded(long l);

    @Unique
    private class_6757<class_2397> leavesDecayTickScheduler;

    @Override
    public class_6757<class_2397> quickleafdecay$getLeavesDecayTickScheduler() {
        return this.leavesDecayTickScheduler;
    }

    @Override
    public void quickleafdecay$scheduleLeavesDecayTick(class_2338 pos, class_2397 leavesBlock, int delay) {
        this.leavesDecayTickScheduler.method_39363(new class_6760<>(
            leavesBlock, pos,
            this.method_8401().method_188() + (long) delay,
            this.method_39224()
        ));
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    private void initFields(CallbackInfo ci) {
        this.leavesDecayTickScheduler = new class_6757<>(this::isChunkLoaded);
    }

    @Inject(
        method = "tick", require = 1, allow = 1,
        at = @At(
            value = "INVOKE", shift = At.Shift.AFTER,
            target = "Lnet/minecraft/world/tick/WorldTickScheduler;tick(JILjava/util/function/BiConsumer;)V"
        ),
        slice = @Slice(
            from = @At(
                value = "FIELD",
                target = "Lnet/minecraft/server/world/ServerWorld;blockTickScheduler:" +
                    "Lnet/minecraft/world/tick/WorldTickScheduler;"
            ),
            to = @At(
                value = "FIELD",
                target = "Lnet/minecraft/server/world/ServerWorld;fluidTickScheduler:" +
                    "Lnet/minecraft/world/tick/WorldTickScheduler;"
            )
        )
    )
    private void tickLeavesDecayScheduler(CallbackInfo ci, @Local class_3695 profiler) {
        profiler.method_15405(LEAVES_DECAY_TICKS_PROFILER_LOCATION);
        this.leavesDecayTickScheduler.method_39377(this.method_8510(), 65536, this::tryDecaying);
    }

    @Unique
    private void tryDecaying(class_2338 pos, class_2397 leavesBlock) {
        final class_2680 state = this.method_8320(pos);
        if (state.method_27852(leavesBlock)) {
            ((AbstractLeavesBlockMixinAccessor) leavesBlock).quickleafdecay$tryDecaying(
                (class_3218)(Object) this, pos, state, this.field_9229
            );
        }
    }
}
