package dev.blueon.quickleafdecay.mixin;

import dev.blueon.quickleafdecay.mixin_helper.PackedTicksMixinAccessor;
import dev.blueon.quickleafdecay.mixin_helper.ServerWorldMixinAccessor;
import dev.blueon.quickleafdecay.mixin_helper.WorldChunkMixinAccessor;
import net.minecraft.class_2397;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_6755;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2818.class)
abstract class WorldChunkMixin extends class_2791 implements WorldChunkMixinAccessor {
    @Unique
    private class_6755<class_2397> leavesDecayTickScheduler;

    private WorldChunkMixin() {
        //noinspection DataFlowIssue
        super(null, null, null, null, 0, null, null);
        throw new IllegalStateException("Dummy constructor called!");
    }

    @Override
    public void quickleafdecay$setLeavesDecayTickScheduler(
        class_6755<class_2397> leavesDecayTickScheduler
    ) {
        this.leavesDecayTickScheduler = leavesDecayTickScheduler;
    }

    @Inject(
        method = "<init>(Lnet/minecraft/world/World;Lnet/minecraft/util/math/ChunkPos;" +
            "Lnet/minecraft/world/chunk/UpgradeData;Lnet/minecraft/world/tick/ChunkTickScheduler;" +
            "Lnet/minecraft/world/tick/ChunkTickScheduler;J[Lnet/minecraft/world/chunk/ChunkSection;" +
            "Lnet/minecraft/world/chunk/WorldChunk$EntityLoader;Lnet/minecraft/world/gen/chunk/BlendingData;)V",
        at = @At("TAIL")
    )
    private void initFields(CallbackInfo ci) {
        this.leavesDecayTickScheduler = new class_6755<>();
    }

    @Inject(method = "addChunkTickSchedulers", at = @At("TAIL"))
    private void scheduleInitialLeavesDecayTicks(class_3218 world, CallbackInfo ci) {
        long time = world.method_8510();
        this.leavesDecayTickScheduler.method_39364(time);
    }

    @Inject(method = "addChunkTickSchedulers", at = @At("TAIL"))
    private void addLeavesDecayTickScheduler(class_3218 world, CallbackInfo ci) {
        ((ServerWorldMixinAccessor) world).quickleafdecay$getLeavesDecayTickScheduler()
            .method_39379(this.field_34538, this.leavesDecayTickScheduler);
    }

    @Inject(method = "removeChunkTickSchedulers", at = @At("TAIL"))
    private void removeLeavesDecayTickScheduler(class_3218 world, CallbackInfo ci) {
        ((ServerWorldMixinAccessor) world).quickleafdecay$getLeavesDecayTickScheduler()
            .method_39378(this.field_34538);
    }

    @Inject(method = "getTickSchedulers", at = @At("RETURN"))
    private void packLeavesDecayTicks(long time, CallbackInfoReturnable<class_2791.class_6745> cir) {
        ((PackedTicksMixinAccessor) (Object) cir.getReturnValue()).quickleafdecay$setLeavesDecayTicks(
            this.leavesDecayTickScheduler.method_61898(time)
        );
    }
}
