/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrgucci1.areaPlanter;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AreaPlanter
extends JavaPlugin
implements Listener {
    private int plantingRadius;

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (this.isValidFarmland(clickedBlock) && this.isValidSeed(heldItem)) {
            int seedsUsed = this.plantArea(clickedBlock, heldItem.getType(), player);
            this.consumeSeed(player, seedsUsed);
        }
    }

    private int plantArea(Block centerBlock, Material seedType, Player player) {
        int seedsPlanted = 0;
        int seedsAvailable = player.getInventory().getItemInMainHand().getAmount();
        int distanceFromCenter = this.plantingRadius / 2;
        for (int x = -distanceFromCenter; x <= distanceFromCenter; ++x) {
            for (int z = -distanceFromCenter; z <= distanceFromCenter; ++z) {
                Block blockBelow = centerBlock.getRelative(x, 0, z);
                Block blockToPlant = centerBlock.getRelative(x, 1, z);
                if (!this.isValidFarmland(blockBelow) || seedsPlanted >= seedsAvailable || blockToPlant.getType() != Material.AIR) continue;
                blockToPlant.setType(this.getCropsFromSeed(seedType));
                ++seedsPlanted;
            }
        }
        return seedsPlanted;
    }

    private boolean isValidFarmland(Block block) {
        return block.getType() == Material.FARMLAND;
    }

    private boolean isValidSeed(ItemStack item) {
        Material itemType = item.getType();
        return itemType == Material.WHEAT_SEEDS || itemType == Material.BEETROOT_SEEDS || itemType == Material.POTATO || itemType == Material.CARROT || itemType == Material.PUMPKIN_SEEDS || itemType == Material.MELON_SEEDS;
    }

    private Material getCropsFromSeed(Material seedType) {
        switch (seedType) {
            case WHEAT_SEEDS: {
                return Material.WHEAT;
            }
            case BEETROOT_SEEDS: {
                return Material.BEETROOTS;
            }
            case POTATO: {
                return Material.POTATOES;
            }
            case CARROT: {
                return Material.CARROTS;
            }
            case PUMPKIN_SEEDS: {
                return Material.PUMPKIN_STEM;
            }
            case MELON_SEEDS: {
                return Material.MELON_STEM;
            }
        }
        return Material.AIR;
    }

    private void consumeSeed(Player player, int seedsUsed) {
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem.getAmount() <= seedsUsed) {
            player.getInventory().setItemInMainHand(null);
        } else {
            heldItem.setAmount(heldItem.getAmount() - seedsUsed);
        }
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.plantingRadius = this.getConfig().getInt("planting-radius", 3);
    }

    public void setPlantingRadius(int plantingRadius) {
        this.getConfig().set("planting-radius", (Object)plantingRadius);
        this.saveConfig();
        this.plantingRadius = plantingRadius;
    }

    public void onEnable() {
        int plantingRadius;
        this.getLogger().info("\n _____             _____ _         _              _____        _____         _   _       _ \n|  _  |___ ___ ___|  _  | |___ ___| |_ ___ ___   |     |___   |   __|___ ___| |_| |___ _| |\n|     |  _| -_| .'|   __| | .'|   |  _| -_|  _|  |-   -|_ -|  |   __|   | .'| . | | -_| . |\n|__|__|_| |___|__,|__|  |_|__,|_|_|_| |___|_|    |_____|___|  |_____|_|_|__,|___|_|___|___|");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.plantingRadius = plantingRadius = this.getConfig().getInt("planting-radius", 3);
    }

    public void onDisable() {
        this.getLogger().info("AreaPlanter has been disabled.");
    }
}

