/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config;

import chrono.mods.compassribbon.config.value.BooleanValue;
import chrono.mods.compassribbon.config.value.EnumValue;
import chrono.mods.compassribbon.config.value.IntegerValue;
import chrono.mods.compassribbon.config.value.OpacityValue;
import chrono.mods.compassribbon.helpers.InventoryUtils;
import org.jetbrains.annotations.NotNull;

public class CompassRibbonConfig {
    public IntegerValue ribbonWidth = new IntegerValue(90, 30, 100);
    public IntegerValue ribbonRange = (IntegerValue)new IntegerValue(240, 29, 360).storedMinValue(0);
    public IntegerValue ribbonYOffset = new IntegerValue(0, 0, 50);
    public OpacityValue fovHighlightOpacity = new OpacityValue(30);
    public EnumValue<@NotNull FovHighlightColor> fovHighlightColor = new EnumValue<FovHighlightColor>(FovHighlightColor.WHITE);
    public EnumValue<@NotNull FovHighlightShape> fovHighlightShape = new EnumValue<FovHighlightShape>(FovHighlightShape.LINE1);
    public EnumValue<@NotNull CompassSlot> directionsCompassSlot = new EnumValue<CompassSlot>(CompassSlot.HAND);
    public EnumValue<@NotNull DirectionsVisibility> directionsInNether = new EnumValue<DirectionsVisibility>(DirectionsVisibility.HIDDEN);
    public EnumValue<@NotNull DirectionsVisibility> directionsInEnd = new EnumValue<DirectionsVisibility>(DirectionsVisibility.HIDDEN);
    public OpacityValue directionsOpacity = new OpacityValue(40);
    public EnumValue<@NotNull DirectionsColor> directionsColor = new EnumValue<DirectionsColor>(DirectionsColor.ORANGE_WHITE);
    public EnumValue<@NotNull MapSlot> mapMarkersMapSlot = new EnumValue<MapSlot>(MapSlot.HOT_BAR);
    public OpacityValue mapMarkersOpacity = new OpacityValue(80);
    public IntegerValue mapMarkersMinimalDistance = new IntegerValue(2, 0, 32);
    public BooleanValue mapMarkersShowFrame = new BooleanValue(false);
    public OpacityValue mapMarkerDescriptionOpacity = new OpacityValue(0);
    public EnumValue<@NotNull FovHighlightColor> mapMarkerDescriptionColor = new EnumValue<FovHighlightColor>(FovHighlightColor.WHITE);
    public EnumValue<@NotNull MapMarkerDescriptionStyle> mapMarkerDescriptionStyle = new EnumValue<MapMarkerDescriptionStyle>(MapMarkerDescriptionStyle.NAME);
    public EnumValue<@NotNull MapMarkerCharmAtlasCompat> mapMarkerCharmAtlasCompat = new EnumValue<MapMarkerCharmAtlasCompat>(MapMarkerCharmAtlasCompat.OFF);
    public BooleanValue hideOnDebugScreen = new BooleanValue(true);

    public static enum FovHighlightColor {
        BLACK(0),
        WHITE(0xFFFFFF);

        private final int color;

        private FovHighlightColor(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static enum FovHighlightShape {
        RECTANGLE,
        LINE1,
        LINE2;

    }

    public static enum CompassSlot {
        NONE(InventoryUtils.ItemSlot.NONE),
        INVENTORY(InventoryUtils.ItemSlot.INVENTORY),
        HOT_BAR(InventoryUtils.ItemSlot.HOT_BAR),
        HAND(InventoryUtils.ItemSlot.HAND);

        private final InventoryUtils.ItemSlot slot;

        private CompassSlot(InventoryUtils.ItemSlot slot) {
            this.slot = slot;
        }

        public InventoryUtils.ItemSlot getSlot() {
            return this.slot;
        }
    }

    public static enum DirectionsVisibility {
        NORMAL,
        RANDOM,
        HIDDEN;

    }

    public static enum DirectionsColor {
        WHITE(0xFFFFFF),
        ORANGE_WHITE(0xFFAA00, 0xFFFFFF),
        RED_WHITE(0xFF0000, 0xFFFFFF),
        GREEN(65280);

        private final int color1;
        private final int color2;

        private DirectionsColor(int color1, int color2) {
            this.color1 = color1;
            this.color2 = color2;
        }

        private DirectionsColor(int color) {
            this(color, color);
        }

        public int getColor1() {
            return this.color1;
        }

        public int getColor2() {
            return this.color2;
        }
    }

    public static enum MapSlot {
        INVENTORY(InventoryUtils.ItemSlot.INVENTORY),
        HOT_BAR(InventoryUtils.ItemSlot.HOT_BAR),
        HAND(InventoryUtils.ItemSlot.HAND);

        private final InventoryUtils.ItemSlot slot;

        private MapSlot(InventoryUtils.ItemSlot slot) {
            this.slot = slot;
        }

        public InventoryUtils.ItemSlot getSlot() {
            return this.slot;
        }
    }

    public static enum MapMarkerDescriptionStyle {
        DISTANCE(true, false),
        NAME(false, true),
        NAME_DISTANCE(true, true);

        private final boolean distance;
        private final boolean name;

        private MapMarkerDescriptionStyle(boolean distance, boolean name) {
            this.distance = distance;
            this.name = name;
        }

        public boolean showDistance() {
            return this.distance;
        }

        public boolean showName() {
            return this.name;
        }
    }

    public static enum MapMarkerCharmAtlasCompat {
        OFF,
        ACTIVE,
        ALL;

    }
}

