/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.value;

import com.google.gson.JsonElement;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractValue<T, @NotNull V> {
    private final V defaultValue;
    private boolean saveDefaultValue;
    private V value;

    public AbstractValue(V defaultValue) {
        this.value = defaultValue;
        this.defaultValue = this.value;
        this.saveDefaultValue = true;
    }

    public T saveDefaultValue(boolean saveDefaultValue) {
        this.saveDefaultValue = saveDefaultValue;
        return this.getThis();
    }

    public boolean isDefaultValue() {
        return this.value.equals(this.defaultValue);
    }

    public boolean getSaveDefaultValue() {
        return this.saveDefaultValue;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void resetValue() {
        this.value = this.defaultValue;
    }

    public abstract JsonElement toJson();

    public abstract void fromJson(JsonElement var1);

    protected abstract T getThis();
}

