/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.value;

import chrono.mods.compassribbon.config.value.AbstractValue;
import com.google.common.base.CaseFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class EnumValue<@NotNull V extends Enum<V>>
extends AbstractValue<EnumValue<V>, V> {
    private final Map<String, V> nameToConstant = new HashMap<String, V>();
    private final Map<V, String> constantToName = new HashMap<V, String>();
    private final V[] constants;

    public EnumValue(V defaultValue) {
        super(defaultValue);
        for (V constant : this.constants = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants()) {
            String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((Enum)constant).name());
            this.nameToConstant.put(name, constant);
            this.constantToName.put((String)constant, name);
        }
    }

    public void cycleValue(boolean backward) {
        int amount = backward ? -1 : 1;
        this.setValue(this.constants[class_3532.method_15387((int)(((Enum)this.getValue()).ordinal() + amount), (int)this.constants.length)]);
    }

    public void cycleValue() {
        this.cycleValue(false);
    }

    public String getName(V value) {
        return this.constantToName.get(value);
    }

    public String getName() {
        return this.getName((Enum)this.getValue());
    }

    @Override
    public JsonElement toJson() {
        return new JsonPrimitive(this.constantToName.get(this.getValue()));
    }

    @Override
    public void fromJson(JsonElement element) {
        Enum constant;
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && (constant = (Enum)this.nameToConstant.get(element.getAsString())) != null) {
            this.setValue(constant);
        }
    }

    @Override
    protected EnumValue<V> getThis() {
        return this;
    }
}

