/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.value;

import chrono.mods.compassribbon.config.value.AbstractValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

public abstract class NumericValue<T extends AbstractValue<T, V>, @NotNull V extends Number>
extends AbstractValue<T, V> {
    private final V minValue;
    private final V maxValue;
    private V step;
    private V storedMinValue;
    private V storedMaxValue;

    public NumericValue(V defaultValue, V minValue, V maxValue, V step) {
        super(defaultValue);
        this.storedMinValue = minValue;
        this.minValue = this.storedMinValue;
        this.storedMaxValue = maxValue;
        this.maxValue = this.storedMaxValue;
        this.step = step;
    }

    public T step(V step) {
        this.step = step;
        return (T)((AbstractValue)this.getThis());
    }

    public T storedMinValue(V value) {
        this.storedMinValue = value;
        return (T)((AbstractValue)this.getThis());
    }

    public T storedMaxValue(V value) {
        this.storedMaxValue = value;
        return (T)((AbstractValue)this.getThis());
    }

    public V getMinValue() {
        return this.minValue;
    }

    public V getMaxValue() {
        return this.maxValue;
    }

    public V getStep() {
        return this.step;
    }

    public boolean isMaxValue() {
        return this.isMaxValue((Number)this.getValue());
    }

    public boolean isMaxValue(V value) {
        return ((Comparable)value).compareTo(this.maxValue) >= 0;
    }

    public boolean isMinValue() {
        return this.isMinValue((Number)this.getValue());
    }

    public boolean isMinValue(V value) {
        return ((Comparable)value).compareTo(this.minValue) <= 0;
    }

    private double round(double value, double step) {
        double rounded;
        if (step <= 0.0) {
            return value;
        }
        if (Math.abs((value /= step) - (rounded = Math.rint(value))) == 0.5) {
            rounded = value + Math.copySign(0.5, value);
        }
        return rounded * step;
    }

    protected double adjustValue(double value) {
        if ((value = this.round(value, ((Number)this.step).doubleValue())) <= ((Number)this.minValue).doubleValue()) {
            value = ((Number)this.storedMinValue).doubleValue();
        } else if (value >= ((Number)this.maxValue).doubleValue()) {
            value = ((Number)this.storedMaxValue).doubleValue();
        }
        return value;
    }

    @Override
    public JsonElement toJson() {
        return new JsonPrimitive((Number)this.getValue());
    }

    @Override
    public void fromJson(JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            this.fromDouble(element.getAsDouble());
        }
    }

    public abstract void fromDouble(double var1);
}

