/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.gui;

import chrono.mods.compassribbon.compat.Charm;
import chrono.mods.compassribbon.config.CompassRibbonConfig;
import chrono.mods.compassribbon.helpers.GameRendererAccessor;
import chrono.mods.compassribbon.helpers.InventoryUtils;
import chrono.mods.compassribbon.helpers.MapInfo;
import chrono.mods.compassribbon.helpers.MapMarker;
import chrono.mods.compassribbon.helpers.RibbonMapMarker;
import chrono.mods.compassribbon.mixin.client.BossHealthOverlayAccessor;
import chrono.mods.compassribbon.network.ClientNetworkHandler;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_10209;
import net.minecraft.class_10472;
import net.minecraft.class_10473;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_11566;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_21;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_811;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

public class CompassRibbonOverlay {
    private static final int BOSSBAR_HEIGHT = 19;
    private static final int RIBBON_HEIGHT = 10;
    private static final int FOV_HIGHLIGHT_LINE2_GAP = 3;
    private static final double FOV_HIGHLIGHT_WIDTH_FOR_DYNAMIC_RANGE = 0.5;
    private static final int MAP_MARKER_DISTANCE_MAX_DISTANCE_FROM_CENTER = 4;
    private static final long MAP_MARKER_DISTANCE_FADE_TIME = 250L;
    private final class_310 minecraft;
    private final CompassRibbonConfig config;
    private final List<class_2561> directions;
    private final class_10472 compassAngle;
    private class_327 font;
    private class_746 player;
    private class_243 viewerPosition;
    private double viewerRotation;
    private int windowWidth;
    private int windowHeight;
    private int windowCenterX;
    private double guiScale;
    private double ribbonRange;
    private int ribbonWidth;
    private int ribbonYOffset;
    private int fovHighlightWidth;
    private static RibbonMapMarker visibleMarker;
    private static double visibleMarkerDx;
    private static long visibleMarkerTime;

    public CompassRibbonOverlay(class_310 minecraft, CompassRibbonConfig config) {
        this.minecraft = minecraft;
        this.config = config;
        this.directions = Arrays.asList("S", "SW", "W", "NW", "N", "NE", "E", "SE").stream().map(direction -> class_2561.method_43471((String)("text.cr-compass-ribbon.direction." + direction))).collect(Collectors.toList());
        this.compassAngle = new class_10472(true, class_10473.class_10474.field_55555);
    }

    public void render(class_332 gui, class_9779 timer) {
        boolean showDirections;
        if (this.minecraft.field_1690.field_1842) {
            return;
        }
        if (((Boolean)this.config.hideOnDebugScreen.getValue()).booleanValue() && this.minecraft.method_53526().method_53536()) {
            return;
        }
        if (!InventoryUtils.containsItem(this.minecraft.field_1724.method_31548(), ((CompassRibbonConfig.CompassSlot)((Object)this.config.directionsCompassSlot.getValue())).getSlot(), class_1802.field_8251)) {
            return;
        }
        this.font = this.minecraft.field_1705.method_1756();
        this.player = this.minecraft.field_1724;
        class_4184 camera = this.minecraft.field_1773.method_19418();
        if (camera.method_19332()) {
            this.viewerPosition = camera.method_19326();
            this.viewerRotation = camera.method_19330();
        } else {
            this.viewerPosition = this.player.method_33571();
            this.viewerRotation = this.player.method_36454();
        }
        boolean showMapMarkers = !this.config.mapMarkersOpacity.isTransparent();
        boolean bl = showDirections = !this.config.directionsOpacity.isTransparent();
        if (showDirections && this.player.method_73183().method_27983() == class_1937.field_25180) {
            if (this.config.directionsInNether.getValue() == CompassRibbonConfig.DirectionsVisibility.HIDDEN) {
                showDirections = false;
            }
        } else if (showDirections && this.player.method_73183().method_27983() == class_1937.field_25181 && this.config.directionsInEnd.getValue() == CompassRibbonConfig.DirectionsVisibility.HIDDEN) {
            showDirections = false;
        }
        if (!showDirections && !showMapMarkers) {
            return;
        }
        this.windowWidth = this.minecraft.method_22683().method_4486();
        this.windowHeight = this.minecraft.method_22683().method_4502();
        this.windowCenterX = this.windowWidth / 2;
        this.guiScale = this.minecraft.method_22683().method_4495();
        this.ribbonYOffset = (Integer)this.config.ribbonYOffset.getValue() + 2 + this.getBossbarHeight(gui);
        this.ribbonWidth = this.windowWidth * (Integer)this.config.ribbonWidth.getValue() / 100;
        double windowAspectRatio = (double)this.windowWidth / (double)this.windowHeight;
        float partialTick = timer.method_60637(true);
        double verticalFov = ((GameRendererAccessor)this.minecraft.field_1773).cr$getFov(partialTick);
        double horizontalFov = Math.atan(Math.tan(verticalFov / 360.0 * Math.PI) * windowAspectRatio) / Math.PI * 360.0;
        this.ribbonRange = this.config.ribbonRange.isMinValue() ? horizontalFov / 0.5 : (double)((Integer)this.config.ribbonRange.getValue()).intValue();
        this.fovHighlightWidth = (int)(Math.min(1.0, horizontalFov / this.ribbonRange) * (double)this.ribbonWidth);
        class_10209.method_64146().method_15396("compass ribbon");
        this.renderCenterMark(gui);
        if (!this.config.fovHighlightOpacity.isTransparent()) {
            this.renderFovHighlight(gui);
        }
        if (showDirections) {
            this.renderDirections(gui);
        }
        if (showMapMarkers) {
            this.renderMarkers(gui, this.minecraft.method_72703().method_73025(class_10725.field_56386));
            this.renderMarkerDescription(gui);
        }
        class_10209.method_64146().method_15407();
    }

    private int getBossbarHeight(class_332 gui) {
        return Math.min(((BossHealthOverlayAccessor)this.minecraft.field_1705.method_1740()).cr$getEvents().size(), gui.method_51443() / 3 / 19) * 19;
    }

    private List<class_9209> getMapIds(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8204) {
            class_9209 mapId = (class_9209)stack.method_58694(class_9334.field_49646);
            if (mapId != null) {
                return List.of(mapId);
            }
        } else if (stack.method_7909() == Charm.getItem()) {
            return Charm.getMapIds(stack, (CompassRibbonConfig.MapMarkerCharmAtlasCompat)((Object)this.config.mapMarkerCharmAtlasCompat.getValue()));
        }
        return List.of();
    }

    private List<RibbonMapMarker> getMarkersInRange() {
        if (this.config.mapMarkersOpacity.isTransparent()) {
            return Lists.newArrayList();
        }
        class_5321 playerDimension = this.player.method_73183().method_27983();
        HashSet<RibbonMapMarker> ribbonMarkers = new HashSet<RibbonMapMarker>();
        HashSet<class_1792> items = new HashSet<class_1792>();
        items.add(class_1802.field_8204);
        if (this.config.mapMarkerCharmAtlasCompat.getValue() != CompassRibbonConfig.MapMarkerCharmAtlasCompat.OFF && Charm.isPresent()) {
            items.add(Charm.getItem());
        }
        List<class_1799> stacks = InventoryUtils.findItems(this.minecraft.field_1724.method_31548(), ((CompassRibbonConfig.MapSlot)((Object)this.config.mapMarkersMapSlot.getValue())).getSlot(), items);
        for (class_1799 stack : stacks) {
            for (class_9209 mapId : this.getMapIds(stack)) {
                MapInfo mapInfo = ClientNetworkHandler.getMapInfo(mapId);
                if (mapInfo == null || !mapInfo.getDimension().equals((Object)playerDimension.method_29177())) continue;
                double maxDistance = mapInfo.getMaxDistance();
                for (MapMarker marker : mapInfo.getMarkers(this.player.method_73189())) {
                    if (!((Boolean)this.config.mapMarkersShowFrame.getValue()).booleanValue() && marker.getType().method_55838(class_21.field_95)) continue;
                    ribbonMarkers.add(new RibbonMapMarker(this.viewerPosition, this.viewerRotation, marker, maxDistance));
                }
            }
        }
        double minimalDistance = ClientNetworkHandler.recentChange() ? 0.0 : (double)((Integer)this.config.mapMarkersMinimalDistance.getValue()).intValue();
        double maxYawDifference = this.ribbonRange / 2.0;
        return ribbonMarkers.stream().filter(ribbonMarker -> Math.abs(ribbonMarker.getYaw()) <= maxYawDifference && ribbonMarker.getDistance() >= minimalDistance).sorted(Comparator.comparingDouble(RibbonMapMarker::getDistance).reversed()).collect(Collectors.toList());
    }

    private double getRibbonAngle() {
        if (this.player.method_73183().method_27983() == class_1937.field_25180 && this.config.directionsInNether.getValue() == CompassRibbonConfig.DirectionsVisibility.RANDOM || this.player.method_73183().method_27983() == class_1937.field_25181 && this.config.directionsInEnd.getValue() == CompassRibbonConfig.DirectionsVisibility.RANDOM) {
            float angle = this.compassAngle.method_65644(new class_1799((class_1935)class_1802.field_8251), this.minecraft.field_1687, (class_11566)this.player, this.player.method_5628() + class_811.field_4317.ordinal());
            return angle * 360.0f - 90.0f;
        }
        return this.viewerRotation;
    }

    private void renderCenterMark(class_332 gui) {
        int color;
        class_10209.method_64146().method_15396("center mark");
        switch ((CompassRibbonConfig.FovHighlightShape)((Object)this.config.fovHighlightShape.getValue())) {
            case RECTANGLE: {
                int n = 0xFFFFFF + this.opacityToAlpha((Integer)this.config.directionsOpacity.getValue());
                break;
            }
            default: {
                int n = color = ((CompassRibbonConfig.FovHighlightColor)((Object)this.config.fovHighlightColor.getValue())).getColor() + this.opacityToAlpha((Integer)this.config.fovHighlightOpacity.getValue());
            }
        }
        if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.RECTANGLE) {
            gui.method_25294(this.windowCenterX, this.ribbonYOffset - 2, this.windowCenterX + 1, this.ribbonYOffset, color);
        }
        if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.LINE2) {
            gui.method_25294(this.windowCenterX, this.ribbonYOffset + 10 - 1, this.windowCenterX + 1, this.ribbonYOffset + 10 + 1, color);
        } else {
            gui.method_25294(this.windowCenterX, this.ribbonYOffset + 10, this.windowCenterX + 1, this.ribbonYOffset + 10 + 2, color);
        }
        class_10209.method_64146().method_15407();
    }

    private void renderDirections(class_332 gui) {
        class_10209.method_64146().method_15396("directions");
        double ribbonAngle = this.getRibbonAngle();
        double ribbonStartAngle = ribbonAngle - this.ribbonRange / 2.0;
        double ribbonEndAngle = ribbonStartAngle + this.ribbonRange;
        for (double angle = (double)class_3532.method_15384((double)(ribbonStartAngle / 45.0)) * 45.0; angle <= ribbonEndAngle; angle += 45.0) {
            int direction = class_3532.method_15384((double)((angle - 22.5) / 45.0)) & 7;
            double position = class_3532.method_15338((double)(angle - ribbonAngle)) / this.ribbonRange;
            int color = direction % 2 == 0 ? ((CompassRibbonConfig.DirectionsColor)((Object)this.config.directionsColor.getValue())).getColor1() : ((CompassRibbonConfig.DirectionsColor)((Object)this.config.directionsColor.getValue())).getColor2();
            int opacity = (int)((float)((Integer)this.config.directionsOpacity.getValue()).intValue() * this.positionToAlpha((float)position));
            if (opacity <= 3) continue;
            class_2561 label = this.directions.get(direction);
            double x = (double)this.windowCenterX + position * (double)this.ribbonWidth - (double)this.font.method_27525((class_5348)label) / 2.0;
            int y = this.ribbonYOffset + 10 - 8;
            gui.method_51448().pushMatrix();
            gui.method_51448().translate((float)this.alignToGuiScale(x), (float)y);
            gui.method_51439(this.font, label, 0, 0, color + this.opacityToAlpha(opacity), false);
            gui.method_51448().popMatrix();
        }
        class_10209.method_64146().method_15407();
    }

    private void renderFovHighlight(class_332 gui) {
        class_10209.method_64146().method_15396("fov highlight");
        int halfWidth = this.fovHighlightWidth / 2;
        int color = ((CompassRibbonConfig.FovHighlightColor)((Object)this.config.fovHighlightColor.getValue())).getColor() + this.opacityToAlpha((Integer)this.config.fovHighlightOpacity.getValue());
        if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.RECTANGLE) {
            gui.method_25294(this.windowCenterX - halfWidth, this.ribbonYOffset, this.windowCenterX + halfWidth + 1, this.ribbonYOffset + 10, color);
        } else if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.LINE1) {
            gui.method_25294(this.windowCenterX - halfWidth, this.ribbonYOffset + 10 - 1, this.windowCenterX + halfWidth + 1, this.ribbonYOffset + 10, color);
        } else if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.LINE2 && halfWidth > 3) {
            gui.method_25294(this.windowCenterX - halfWidth, this.ribbonYOffset + 10 - 1, this.windowCenterX - 3, this.ribbonYOffset + 10, color);
            gui.method_25294(this.windowCenterX + 3 + 1, this.ribbonYOffset + 10 - 1, this.windowCenterX + halfWidth + 1, this.ribbonYOffset + 10, color);
        }
        class_10209.method_64146().method_15407();
    }

    private void renderMarkers(class_332 gui, class_1059 decorationAtlas) {
        List<RibbonMapMarker> markers = this.getMarkersInRange();
        if (markers.isEmpty()) {
            return;
        }
        class_10209.method_64146().method_15396("markers");
        gui.method_44379(0, this.ribbonYOffset, this.windowWidth, this.ribbonYOffset + 10);
        boolean showMarkerDescription = !this.config.mapMarkerDescriptionOpacity.isTransparent();
        long now = class_156.method_658();
        int z = 1;
        for (RibbonMapMarker marker : markers) {
            double markerPosition = marker.getYaw() / this.ribbonRange;
            double dx = markerPosition * (double)this.ribbonWidth;
            double x = (double)this.windowCenterX + dx;
            double y = (double)this.ribbonYOffset + Math.max(marker.getPitch() / 15.0, -3.0);
            int opacity = (int)((float)((Integer)this.config.mapMarkersOpacity.getValue()).intValue() * this.positionToAlpha((float)markerPosition) * this.distanceToAlpha((float)marker.getDistance()) * 255.0f / 100.0f);
            this.renderMarker(gui, decorationAtlas, x, y, z++, marker, opacity);
            if (!showMarkerDescription) continue;
            if (Math.abs(dx) <= 4.0) {
                if (visibleMarker != null && !marker.equals(visibleMarker) && !(Math.abs(dx) <= Math.abs(visibleMarkerDx))) continue;
                visibleMarker = marker;
                visibleMarkerDx = dx;
                visibleMarkerTime = now;
                continue;
            }
            if (!marker.equals(visibleMarker)) continue;
            visibleMarkerDx = dx;
        }
        gui.method_44380();
        class_10209.method_64146().method_15407();
    }

    private void renderMarker(class_332 gui, class_1059 decorationAtlas, double x, double y, int z, RibbonMapMarker marker, int opacity) {
        if (opacity == 0) {
            return;
        }
        class_1058 sprite = decorationAtlas.method_4608(marker.getAssetId());
        gui.method_51448().pushMatrix();
        gui.method_51448().translate((float)this.alignToGuiScale(x + 0.5), (float)this.alignToGuiScale(y + 4.5));
        gui.method_51448().scale(4.0f, 4.0f);
        gui.method_70845(sprite.method_45852(), -1, -1, 1, 1, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
        gui.method_51448().popMatrix();
    }

    private void renderMarkerDescription(class_332 gui) {
        if (visibleMarker == null) {
            return;
        }
        long now = class_156.method_658();
        if (visibleMarkerTime + 250L < now) {
            visibleMarker = null;
            return;
        }
        int opacity = (int)Math.round(class_3532.method_16436((double)((double)(now - visibleMarkerTime) / 250.0), (double)1.0, (double)0.0) * (double)((Integer)this.config.mapMarkerDescriptionOpacity.getValue()).intValue());
        if (opacity <= 3) {
            return;
        }
        String name = visibleMarker.getName();
        CompassRibbonConfig.MapMarkerDescriptionStyle style = (CompassRibbonConfig.MapMarkerDescriptionStyle)((Object)this.config.mapMarkerDescriptionStyle.getValue());
        if (!style.showDistance() && name.isEmpty()) {
            return;
        }
        class_10209.method_64146().method_15396("descriptions");
        if (name.isEmpty() && style.showName()) {
            style = CompassRibbonConfig.MapMarkerDescriptionStyle.DISTANCE;
        }
        class_5250 label = class_2561.method_43469((String)("text.cr-compass-ribbon.mapMarkerDescription." + this.config.mapMarkerDescriptionStyle.getName(style)), (Object[])new Object[]{name, (int)Math.round(visibleMarker.getDistance())});
        double labelWidth = this.font.method_27525((class_5348)label);
        double x = Math.max(0.0, Math.min((double)this.windowWidth - labelWidth, (double)this.windowCenterX + visibleMarkerDx - labelWidth / 2.0));
        int y = this.ribbonYOffset + 10 + 2;
        gui.method_51448().pushMatrix();
        gui.method_51448().translate((float)this.alignToGuiScale(x), (float)y);
        gui.method_51439(this.font, (class_2561)label, 0, 0, ((CompassRibbonConfig.FovHighlightColor)((Object)this.config.mapMarkerDescriptionColor.getValue())).getColor() + this.opacityToAlpha(opacity), false);
        gui.method_51448().popMatrix();
        class_10209.method_64146().method_15407();
    }

    private double alignToGuiScale(double value) {
        if (this.guiScale == 1.0) {
            return Math.round(value);
        }
        return (double)Math.round(value * this.guiScale) / this.guiScale;
    }

    private float distanceToAlpha(float distance) {
        return (1.0f - Math.min(1.0f, distance / 256.0f)) * 0.5f + 0.5f;
    }

    private int opacityToAlpha(int opacity) {
        return opacity * 255 / 100 << 24;
    }

    private float positionToAlpha(float position) {
        return Math.min(1.0f, 3.0f - class_3532.method_15379((float)position) * 6.0f);
    }
}

