/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.helpers;

import chrono.mods.compassribbon.helpers.MapMarker;
import chrono.mods.compassribbon.mixin.server.MapItemSavedDataAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_19;
import net.minecraft.class_1937;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9209;
import net.minecraft.class_9292;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class MapInfo {
    public static final class_9139<class_9129, MapInfo> STREAM_CODEC = class_9139.method_56438(MapInfo::toNetwork, MapInfo::fromNetwork);
    private final class_9209 mapId;
    private final class_2960 dimension;
    private final int x;
    private final int z;
    private final byte scale;
    private final boolean trackingPosition;
    private final boolean unlimitedTracking;
    private final List<MapMarker> markers;
    private static final boolean SORT_MARKERS = true;

    public MapInfo(class_9209 mapId, class_2960 dimension, int x, int z, byte scale, boolean trackingPosition, boolean unlimitedTracking, List<MapMarker> markers) {
        this.mapId = mapId;
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.scale = scale;
        this.trackingPosition = trackingPosition;
        this.unlimitedTracking = unlimitedTracking;
        this.markers = markers;
    }

    @Nullable
    public static MapInfo fromItemStack(class_1799 stack, class_1937 level) {
        class_9209 mapId = (class_9209)stack.method_58694(class_9334.field_49646);
        if (mapId == null) {
            return null;
        }
        class_22 mapData = class_1806.method_7997((class_9209)mapId, (class_1937)level);
        if (mapData == null) {
            return null;
        }
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        for (class_17 bannerMarker : ((MapItemSavedDataAccessor)mapData).cr$getBannerMarkers().values()) {
            markers.add(new MapMarker(bannerMarker.comp_2312(), (class_6880<class_9428>)bannerMarker.method_72(), bannerMarker.comp_2314().map(class_2561::getString).orElse("")));
        }
        for (class_19 frameMarker : ((MapItemSavedDataAccessor)mapData).cr$getFrameMarkers().values()) {
            markers.add(new MapMarker(frameMarker.comp_3491(), (class_6880<class_9428>)class_21.field_95));
        }
        class_9292 mapDecorations = (class_9292)stack.method_58695(class_9334.field_49647, (Object)class_9292.field_49347);
        mapDecorations.comp_2404().values().forEach(decorationMarker -> markers.add(new MapMarker((int)decorationMarker.comp_2406(), 64, (int)decorationMarker.comp_2407(), (class_6880<class_9428>)decorationMarker.comp_2405())));
        Collections.sort(markers);
        return new MapInfo(mapId, mapData.field_118.method_29177(), mapData.field_116, mapData.field_115, mapData.field_119, ((MapItemSavedDataAccessor)mapData).cr$getTrackingPosition(), ((MapItemSavedDataAccessor)mapData).cr$getUnlimitedTracking(), markers);
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public class_9209 getMapId() {
        return this.mapId;
    }

    public List<MapMarker> getMarkers(class_243 pos) {
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        if (this.markers.size() > 0 && this.trackingPosition) {
            double maxDistance = this.getMaxDistance();
            double mapCenterDistance = Math.max(Math.abs(pos.method_10216() - (double)this.x), Math.abs(pos.method_10215() - (double)this.z));
            if (maxDistance == 0.0 || maxDistance >= mapCenterDistance) {
                for (MapMarker marker : this.markers) {
                    markers.add(marker);
                }
            }
        }
        return markers;
    }

    public double getMaxDistance() {
        return this.unlimitedTracking ? 0.0 : (double)(320 << this.scale);
    }

    private static MapInfo fromNetwork(class_9129 buf) {
        class_9209 mapId = (class_9209)class_9209.field_48924.decode((Object)buf);
        class_2960 dimension = buf.method_10810();
        int x = buf.readInt();
        int z = buf.readInt();
        byte scale = buf.readByte();
        boolean trackingPosition = buf.readBoolean();
        boolean unlimitedTracking = buf.readBoolean();
        int count = buf.method_10816();
        ArrayList markers = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            markers.add((MapMarker)MapMarker.STREAM_CODEC.decode((Object)buf));
        }
        return new MapInfo(mapId, dimension, x, z, scale, trackingPosition, unlimitedTracking, markers);
    }

    private void toNetwork(class_9129 buf) {
        class_9209.field_48924.encode((Object)buf, (Object)this.mapId);
        buf.method_10812(this.dimension);
        buf.method_53002(this.x);
        buf.method_53002(this.z);
        buf.method_52997((int)this.scale);
        buf.method_52964(this.trackingPosition);
        buf.method_52964(this.unlimitedTracking);
        buf.method_10804(this.markers.size());
        for (MapMarker mapMarker : this.markers) {
            MapMarker.STREAM_CODEC.encode((Object)buf, (Object)mapMarker);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MapInfo other = (MapInfo)object;
        return this.mapId.equals((Object)other.mapId) && this.dimension == other.dimension && this.x == other.x && this.z == other.z && this.scale == other.scale && this.trackingPosition == other.trackingPosition && this.unlimitedTracking == other.unlimitedTracking && this.markers.equals(other.markers);
    }

    public int hashCode() {
        return Objects.hash(this.mapId, this.dimension, this.x, this.z, this.scale, this.trackingPosition, this.unlimitedTracking, this.markers);
    }

    public String toString() {
        return "mapId: " + String.valueOf(this.mapId) + ", center: " + this.x + "/" + this.z + ", scale: 1/" + (1 << this.scale) + ", " + this.markers.size() + " marker(s): " + String.valueOf(this.markers);
    }
}

