/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.helpers;

import chrono.mods.compassribbon.helpers.MapMarker;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_9428;

public class RibbonMapMarker {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private final int x;
    private final int y;
    private final int z;
    private final class_6880<class_9428> type;
    private final String name;
    private final double distance;
    private final double pitch;
    private final double yaw;
    private final double maxDistance;

    public RibbonMapMarker(class_243 viewerPosition, double viewerRotation, int x, int y, int z, class_6880<class_9428> type, String name, double maxDistance) {
        double rx = (double)x + 0.5 - viewerPosition.field_1352;
        double ry = (double)y + 0.5 - viewerPosition.field_1351;
        double rz = (double)z + 0.5 - viewerPosition.field_1350;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
        this.name = name;
        this.distance = Math.sqrt(rx * rx + rz * rz);
        this.pitch = -class_3532.method_15349((double)ry, (double)Math.max(this.distance, 8.0)) * 57.29577951308232;
        this.yaw = class_3532.method_15338((double)(-(class_3532.method_15349((double)rx, (double)rz) * 57.29577951308232 + viewerRotation)));
        this.maxDistance = maxDistance;
    }

    public RibbonMapMarker(class_243 viewerPosition, double viewerRotation, MapMarker mapMarker, double maxDistance) {
        this(viewerPosition, viewerRotation, mapMarker.getX(), mapMarker.getY(), mapMarker.getZ(), mapMarker.getType(), mapMarker.getName(), maxDistance);
    }

    public class_2960 getAssetId() {
        return ((class_9428)this.type.comp_349()).comp_2514();
    }

    public String getName() {
        return this.name;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RibbonMapMarker)) {
            return false;
        }
        RibbonMapMarker other = (RibbonMapMarker)object;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getAssetId().equals((Object)other.getAssetId()) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.getAssetId(), this.name);
    }

    public String toString() {
        return "RibbonMarker: " + this.distance + "/" + this.maxDistance + ", " + this.pitch + ", " + this.yaw + ", " + String.valueOf(this.type) + ", " + this.name;
    }
}

