/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.network;

import chrono.mods.compassribbon.CompassRibbonClient;
import chrono.mods.compassribbon.helpers.MapInfo;
import chrono.mods.compassribbon.network.MapInfoPayload;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_9209;

public class ClientNetworkHandler {
    private static final Map<class_9209, MapInfo> mapsInfo = new HashMap<class_9209, MapInfo>();
    private static long lastChangeTime = 0L;

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(MapInfoPayload.TYPE, ClientNetworkHandler::updateMapInfo);
    }

    public static void clearMaps() {
        mapsInfo.clear();
        CompassRibbonClient.LOGGER.debug("Client maps cleared");
    }

    public static MapInfo getMapInfo(class_9209 mapId) {
        return mapsInfo.get(mapId);
    }

    public static void updateLastChangeTime() {
        lastChangeTime = class_156.method_658();
    }

    public static boolean recentChange() {
        long diff = class_156.method_658() - lastChangeTime;
        return diff < 5000L && diff % 1000L < 500L;
    }

    private static void updateMapInfo(MapInfoPayload payload, ClientPlayNetworking.Context context) {
        MapInfo mapInfo = payload.mapInfo();
        context.client().execute(() -> {
            mapsInfo.put(mapInfo.getMapId(), mapInfo);
            ClientNetworkHandler.updateLastChangeTime();
            CompassRibbonClient.LOGGER.debug("Client map update: {}", (Object)mapInfo);
        });
    }
}

