/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.network;

import chrono.mods.compassribbon.CompassRibbon;
import chrono.mods.compassribbon.helpers.MapInfo;
import chrono.mods.compassribbon.network.MapInfoPayload;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9209;
import org.jetbrains.annotations.Nullable;

public class ServerNetworkHandler {
    public static final class_2960 MAP_INFO = class_2960.method_60655((String)"cr-compass-ribbon", (String)"map_info");
    private static final Table<UUID, class_9209, MapInfo> playerMapInfo = HashBasedTable.create();

    public static void init() {
        PayloadTypeRegistry.playS2C().register(MapInfoPayload.TYPE, MapInfoPayload.STREAM_CODEC);
    }

    public static void onMapUpdate(class_3222 player, @Nullable MapInfo mapInfo) {
        if (mapInfo == null) {
            return;
        }
        if (mapInfo.equals(playerMapInfo.get((Object)player.method_5667(), (Object)mapInfo.getMapId()))) {
            return;
        }
        playerMapInfo.put((Object)player.method_5667(), (Object)mapInfo.getMapId(), (Object)mapInfo);
        CompassRibbon.LOGGER.debug("Server map update: {}", (Object)mapInfo);
        if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)MAP_INFO)) {
            ServerNetworkHandler.sendMapInfo(player, mapInfo);
        }
    }

    public static void onPlayerDisconnect(class_3222 player) {
        CompassRibbon.LOGGER.debug("Player disconnected: {}", (Object)player);
        playerMapInfo.row((Object)player.method_5667()).clear();
    }

    private static void sendMapInfo(class_3222 player, MapInfo mapInfo) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new MapInfoPayload(mapInfo));
    }
}

