/*
 * Decompiled with CFR 0.152.
 */
package net.wjph.orbitalstrikecannon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.wjph.orbitalstrikecannon.network.StrikeCannonGUIButtonMessage;
import net.wjph.orbitalstrikecannon.world.inventory.StrikeCannonGUIMenu;

public class StrikeCannonGUIScreen
extends AbstractContainerScreen<StrikeCannonGUIMenu> {
    private static final HashMap<String, Object> guistate = StrikeCannonGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    EditBox xcoord;
    EditBox zcoord;
    Button button_1;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"orbital_strike_cannon:textures/screens/strike_cannon_gui.png");

    public StrikeCannonGUIScreen(StrikeCannonGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 238;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.xcoord.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.zcoord.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.xcoord.isFocused()) {
            return this.xcoord.keyPressed(key, b, c);
        }
        if (this.zcoord.isFocused()) {
            return this.zcoord.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String xcoordValue = this.xcoord.getValue();
        String zcoordValue = this.zcoord.getValue();
        super.resize(minecraft, width, height);
        this.xcoord.setValue(xcoordValue);
        this.zcoord.setValue(zcoordValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
        this.xcoord = new EditBox(this, this.font, this.leftPos + 5, this.topPos + 5, 166, 18, (Component)Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.xcoord")){

            public void insertText(String text) {
                super.insertText(text);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.xcoord").getString());
                } else {
                    this.setSuggestion(null);
                }
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.xcoord").getString());
                } else {
                    this.setSuggestion(null);
                }
            }
        };
        this.xcoord.setMaxLength(Short.MAX_VALUE);
        this.xcoord.setSuggestion(Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.xcoord").getString());
        guistate.put("text:xcoord", this.xcoord);
        this.addWidget((GuiEventListener)this.xcoord);
        this.zcoord = new EditBox(this, this.font, this.leftPos + 5, this.topPos + 24, 166, 18, (Component)Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.zcoord")){

            public void insertText(String text) {
                super.insertText(text);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.zcoord").getString());
                } else {
                    this.setSuggestion(null);
                }
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.zcoord").getString());
                } else {
                    this.setSuggestion(null);
                }
            }
        };
        this.zcoord.setMaxLength(Short.MAX_VALUE);
        this.zcoord.setSuggestion(Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.zcoord").getString());
        guistate.put("text:zcoord", this.zcoord);
        this.addWidget((GuiEventListener)this.zcoord);
        this.button_1 = Button.builder((Component)Component.translatable((String)"gui.orbital_strike_cannon.strike_cannon_gui.button_1"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new StrikeCannonGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            StrikeCannonGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 4, this.topPos + 214, 168, 20).build();
        guistate.put("button:button_1", this.button_1);
        this.addRenderableWidget((GuiEventListener)this.button_1);
    }
}

