/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis;

import com.google.gson.Gson;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;

public class SkRedisPluginLoader
implements PluginLoader {
    public void classloader(PluginClasspathBuilder classpathBuilder) {
        MavenLibraryResolver resolver = new MavenLibraryResolver();
        PluginLibraries pluginLibraries = this.load();
        pluginLibraries.asDependencies().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addDependency(arg_0));
        pluginLibraries.asRepositories().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addRepository(arg_0));
        classpathBuilder.addLibrary((ClassPathLibrary)resolver);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PluginLibraries load() {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/paper-libraries.json");){
            PluginLibraries pluginLibraries;
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                pluginLibraries = (PluginLibraries)new Gson().fromJson((Reader)reader, PluginLibraries.class);
            }
            return pluginLibraries;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class PluginLibraries {
        private Map<String, String> repositories;
        private List<String> dependencies;

        public Map<String, String> getRepositories() {
            return this.repositories;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public Stream<Dependency> asDependencies() {
            return this.dependencies.stream().map(d -> new Dependency((Artifact)new DefaultArtifact(d), null));
        }

        public Stream<RemoteRepository> asRepositories() {
            return this.repositories.entrySet().stream().map(entry -> {
                String url = (String)entry.getValue();
                if (url.contains("https://repo1.maven.org/maven2") || url.contains("http://repo1.maven.org/maven2") || url.contains("https://repo.maven.apache.org/maven2") || url.contains("http://repo.maven.apache.org/maven2")) {
                    return new RemoteRepository.Builder("central", "default", MavenLibraryResolver.MAVEN_CENTRAL_DEFAULT_MIRROR).build();
                }
                return new RemoteRepository.Builder((String)entry.getKey(), "default", (String)entry.getValue()).build();
            });
        }
    }
}

