/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.config;

import dev.bypixel.skredis.Main;
import dev.bypixel.skredis.SkRedisLogger;
import dev.bypixel.skredis.config.Config;
import dev.bypixel.skredis.config.LenientPropertyUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.PropertyUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010\u0018\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/bypixel/skredis/config/ConfigLoader;", "", "<init>", "()V", "loaderOptions", "Lorg/yaml/snakeyaml/LoaderOptions;", "constructor", "Lorg/yaml/snakeyaml/constructor/Constructor;", "yaml", "Lorg/yaml/snakeyaml/Yaml;", "value", "Ldev/bypixel/skredis/config/Config;", "config", "getConfig", "()Ldev/bypixel/skredis/config/Config;", "configNeedsSaving", "", "load", "", "save", "reload", "backupConfig", "configFile", "Ljava/io/File;", "mergeRecursive", "defaultMap", "", "", "loadedMap", "", "path", "SkRedis"})
@SourceDebugExtension(value={"SMAP\nConfigLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigLoader.kt\ndev/bypixel/skredis/config/ConfigLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n774#2:176\n865#2,2:177\n216#3,2:179\n1#4:181\n*S KotlinDebug\n*F\n+ 1 ConfigLoader.kt\ndev/bypixel/skredis/config/ConfigLoader\n*L\n148#1:176\n148#1:177,2\n159#1:179,2\n*E\n"})
public final class ConfigLoader {
    @NotNull
    public static final ConfigLoader INSTANCE;
    @NotNull
    private static final LoaderOptions loaderOptions;
    @NotNull
    private static final Constructor constructor;
    @NotNull
    private static final Yaml yaml;
    @Nullable
    private static Config config;
    private static boolean configNeedsSaving;

    private ConfigLoader() {
    }

    @Nullable
    public final Config getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        File configFile = new File("plugins/SkRedis/config.yml");
        configNeedsSaving = false;
        File file = configFile.getParentFile();
        if (file != null) {
            File it = file;
            boolean bl = false;
            if (!it.exists() && !it.mkdirs()) {
                SkRedisLogger.INSTANCE.error((Plugin)Main.Companion.getInstance(), "Failed to create configuration directory at " + it.getAbsolutePath());
            }
        } else {
            return;
        }
        if (!configFile.exists()) {
            SkRedisLogger.INSTANCE.warn((Plugin)Main.Companion.getInstance(), "Configuration file not found! Creating a new one...");
            config = new Config(0, false, null, 7, null);
            configNeedsSaving = true;
            this.save();
            return;
        }
        try {
            Closeable closeable = new FileInputStream(configFile);
            Throwable throwable = null;
            try {
                FileInputStream inputStream = (FileInputStream)closeable;
                boolean bl = false;
                Yaml taglessYaml = new Yaml();
                Map loadedMap = (Map)taglessYaml.load((InputStream)inputStream);
                Config defaultConfig = new Config(0, false, null, 7, null);
                String defaultString = taglessYaml.dumpAsMap((Object)defaultConfig);
                Map defaultMap = (Map)taglessYaml.load(defaultString);
                Intrinsics.checkNotNull((Object)defaultMap);
                Intrinsics.checkNotNull((Object)loadedMap);
                boolean changed = INSTANCE.mergeRecursive(defaultMap, loadedMap, "root");
                String mergedString = taglessYaml.dump((Object)loadedMap);
                config = (Config)yaml.loadAs(mergedString, Config.class);
                if (changed) {
                    configNeedsSaving = true;
                    INSTANCE.save();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            SkRedisLogger.INSTANCE.error((Plugin)Main.Companion.getInstance(), "Failed to load configuration file: " + e.getMessage());
            if (configFile.exists() && configFile.length() > 0L) {
                this.backupConfig(configFile);
            }
            config = new Config(0, false, null, 7, null);
            configNeedsSaving = true;
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        if (!configNeedsSaving && config != null) {
            SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), "No changes to save in the configuration file.");
            return;
        }
        File configFile = new File("plugins/SkRedis/config.yml");
        try {
            Closeable closeable = new FileWriter(configFile);
            Throwable throwable = null;
            try {
                Unit unit;
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                Config config = ConfigLoader.config;
                if (config != null) {
                    Config config2 = config;
                    boolean bl2 = false;
                    writer.write("# This is the internal version of the config, DO NOT MODIFY THIS VALUE\n");
                    writer.write("configVersion: " + config2.getConfigVersion() + "\n\n");
                    writer.write("# whether players with the permission 'skredis.admin.version' should be notified if there is an update.\n");
                    writer.write("updateChecker: " + config2.getUpdateChecker() + "\n\n");
                    writer.write("# Redis configuration\n");
                    writer.write("redis:\n");
                    Config.RedisConfig $this$save_u24lambda_u240_u240_u240 = config2.getRedis();
                    boolean bl3 = false;
                    writer.write("  # The hostname of your redis server, you can use free redis hosting (search for it online) if you do not have the ability to host your own redis server. (https://redis.io/)\n  # A redis server is very lightweight, takes under 30 MB of RAM usually\n");
                    writer.write("  host: " + $this$save_u24lambda_u240_u240_u240.getHost() + "\n");
                    writer.write("  port: " + $this$save_u24lambda_u240_u240_u240.getPort() + "\n");
                    writer.write("  # The username of your redis server, if you do not have a username, leave it as default\n");
                    writer.write("  username: " + $this$save_u24lambda_u240_u240_u240.getUsername() + "\n");
                    writer.write("  # A secure password that cannot be cracked, please change it!\n  # It is also recommended to firewall your redis server with iptables or another firewall, like ufw, so it can only be accessed by specific IP addresses\n");
                    writer.write("  password: " + $this$save_u24lambda_u240_u240_u240.getPassword() + "\n");
                    writer.write("  # Only use this if you're running Redis 6.0.6 or higher, older versions will not work correctly\n  # It encrypts your traffic and makes data exchange between distant servers secure\n");
                    writer.write("  useSsl: " + $this$save_u24lambda_u240_u240_u240.getUseSsl() + "\n");
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            SkRedisLogger.INSTANCE.success((Plugin)Main.Companion.getInstance(), "Configuration saved successfully at " + configFile.getAbsolutePath());
            configNeedsSaving = false;
        }
        catch (Exception e) {
            SkRedisLogger.INSTANCE.error((Plugin)Main.Companion.getInstance(), "Failed to save configuration file: " + e.getMessage());
        }
    }

    public final void reload() {
        SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), "Reloading configuration...");
        Config config = ConfigLoader.config;
        if (config != null) {
            config.getConfigVersion();
        }
        this.load();
        SkRedisLogger.INSTANCE.success((Plugin)Main.Companion.getInstance(), "Configuration reloaded successfully!");
    }

    private final void backupConfig(File configFile) {
        try {
            File backupDir = new File(configFile.getParentFile(), "config-backup");
            if (!backupDir.exists() && !backupDir.mkdirs()) {
                SkRedisLogger.INSTANCE.error((Plugin)Main.Companion.getInstance(), "Failed to create backup directory at " + backupDir.getAbsolutePath());
                return;
            }
            long timestamp = System.currentTimeMillis();
            File backupFile = new File(backupDir, FilesKt.getNameWithoutExtension((File)configFile) + "-" + timestamp + ".yml");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(configFile.toPath(), backupFile.toPath(), copyOptionArray);
            SkRedisLogger.INSTANCE.success((Plugin)Main.Companion.getInstance(), "Backup created successfully at " + backupFile.getAbsolutePath());
        }
        catch (Exception e) {
            SkRedisLogger.INSTANCE.error((Plugin)Main.Companion.getInstance(), "Failed to create backup of config file: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean mergeRecursive(Map<String, ? extends Object> defaultMap, Map<String, Object> loadedMap, String path) {
        void $this$filterTo$iv$iv;
        boolean changed = false;
        Iterable $this$filter$iv = loadedMap.keySet();
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!defaultMap.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keysToRemove = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (!((Collection)keysToRemove).isEmpty()) {
            SkRedisLogger.INSTANCE.warn((Plugin)Main.Companion.getInstance(), "Found unknown keys at " + path + ": " + keysToRemove);
        }
        for (String key : keysToRemove) {
            loadedMap.remove(key);
            changed = true;
            SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), "Removed unknown key: " + path + "." + key);
        }
        Map<String, ? extends Object> $this$forEach$iv = defaultMap;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            Object defaultValue = entry.getValue();
            if (!loadedMap.containsKey(key) || loadedMap.get(key) == null) {
                loadedMap.put(key, defaultValue);
                changed = true;
                SkRedisLogger.INSTANCE.warn((Plugin)Main.Companion.getInstance(), "Added missing key: " + path + "." + key);
                continue;
            }
            if (!(defaultValue instanceof Map) || !(loadedMap.get(key) instanceof Map)) continue;
            Map nestedDefault = (Map)defaultValue;
            Object object2 = loadedMap.get(key);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map nestedLoaded = MapsKt.toMutableMap((Map)((Map)object2));
            if (!INSTANCE.mergeRecursive(nestedDefault, nestedLoaded, path + "." + key)) continue;
            loadedMap.put(key, nestedLoaded);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$constructor_u24lambda_u240_u240;
        LenientPropertyUtils lenientPropertyUtils;
        Constructor constructor;
        INSTANCE = new ConfigLoader();
        loaderOptions = new LoaderOptions();
        Constructor $this$constructor_u24lambda_u240 = constructor = new Constructor(Config.class, loaderOptions);
        boolean bl = false;
        LenientPropertyUtils lenientPropertyUtils2 = lenientPropertyUtils = new LenientPropertyUtils();
        Constructor constructor2 = $this$constructor_u24lambda_u240;
        boolean bl2 = false;
        $this$constructor_u24lambda_u240_u240.setSkipMissingProperties(true);
        constructor2.setPropertyUtils((PropertyUtils)lenientPropertyUtils);
        ConfigLoader.constructor = constructor;
        yaml = new Yaml((BaseConstructor)ConfigLoader.constructor);
        INSTANCE.load();
    }
}

