/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.lettuce.LettuceRedisClient;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Redis Keys - exists")
@Description(value={"Checks if a given key of any type exists in Redis."})
@Examples(value={"on redis message:", "\tif \"cool-test-key\" exists:", "\t\tbroadcast \"Got %redis message% with existing key!\""})
@Since(value={"1.1.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/bypixel/skredis/skript/elements/conditions/CondExists;", "Lch/njol/skript/lang/Condition;", "<init>", "()V", "key", "Lch/njol/skript/lang/Expression;", "", "init", "", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "check", "e", "Lorg/bukkit/event/Event;", "toString", "debug", "Companion", "SkRedis"})
public final class CondExists
extends Condition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Expression<String> key;

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        this.key = expressions[0];
        SkriptParser.ParseResult parseResult2 = parseResult;
        this.setNegated(parseResult2 != null ? parseResult2.mark == 1 : false);
        return true;
    }

    public boolean check(@Nullable Event e) {
        Object object = this.key;
        if (object == null || (object = (String)object.getSingle(e)) == null) {
            return false;
        }
        Object key = object;
        Object[] objectArray = new String[]{key};
        Long l = LettuceRedisClient.INSTANCE.getSync().exists(objectArray);
        long l2 = 0L;
        return (l != null && l == l2) != this.isNegated();
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "exists " + this.key;
    }

    static {
        String[] stringArray = new String[]{"%string% exists"};
        Skript.registerCondition(CondExists.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bypixel/skredis/skript/elements/conditions/CondExists$Companion;", "", "<init>", "()V", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

