/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.Main;
import dev.bypixel.skredis.SkRedisLogger;
import dev.bypixel.skredis.lettuce.LettuceRedisClient;
import dev.bypixel.skredis.utils.SkRedisCoroutineScope;
import io.lettuce.core.api.coroutines.RedisCoroutinesCommands;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Redis Lists - set redis list value")
@Description(value={"Sets a specific index in a Redis list to a new value.", "It will overwrite the value at the given index.", "NOTE: If the index does not already exist, it will fail."})
@Examples(value={"set entry with index 2 in redis list \"myList\" to \"myNewValue\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0014R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/bypixel/skredis/skript/elements/effects/EffSetRedisListValue;", "Lch/njol/skript/lang/Effect;", "<init>", "()V", "listIndex", "Lch/njol/skript/lang/Expression;", "", "listKey", "", "listValue", "init", "", "expressions", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parser", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "toString", "event", "Lorg/bukkit/event/Event;", "debug", "execute", "", "e", "Companion", "SkRedis"})
public final class EffSetRedisListValue
extends Effect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Expression<Number> listIndex;
    @Nullable
    private Expression<String> listKey;
    @Nullable
    private Expression<String> listValue;

    public boolean init(@NotNull Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)isDelayed, (String)"isDelayed");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Expression<?> expression = expressions[0];
        Intrinsics.checkNotNull(expression, (String)"null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.Number>");
        this.listIndex = expression;
        Expression<?> expression2 = expressions[1];
        Intrinsics.checkNotNull(expression2, (String)"null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.listKey = expression2;
        Expression<?> expression3 = expressions[2];
        Intrinsics.checkNotNull(expression3, (String)"null cannot be cast to non-null type ch.njol.skript.lang.Expression<kotlin.String>");
        this.listValue = expression3;
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "set entry with index " + this.listIndex + " in redis list " + this.listKey + " to " + this.listValue;
    }

    protected void execute(@Nullable Event e) {
        Main plugin = Main.Companion.getInstance();
        Expression<Number> expression = this.listIndex;
        Intrinsics.checkNotNull(expression);
        Number listIndexNumber = (Number)expression.getSingle(e);
        if (listIndexNumber == null) {
            SkRedisLogger.INSTANCE.error((Plugin)plugin, "Redis list index was empty. Please check your code.");
            return;
        }
        int listIndex = listIndexNumber.intValue();
        Expression<String> expression2 = this.listKey;
        Intrinsics.checkNotNull(expression2);
        String listKey = (String)expression2.getSingle(e);
        Expression<String> expression3 = this.listValue;
        Intrinsics.checkNotNull(expression3);
        String listValue = (String)expression3.getSingle(e);
        if (listKey == null) {
            SkRedisLogger.INSTANCE.error((Plugin)plugin, "Redis list key was empty. Please check your code.");
            return;
        }
        BuildersKt.launch$default((CoroutineScope)SkRedisCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(listKey, listIndex, listValue, null){
            int label;
            final /* synthetic */ String $listKey;
            final /* synthetic */ int $listIndex;
            final /* synthetic */ String $listValue;
            {
                this.$listKey = $listKey;
                this.$listIndex = $listIndex;
                this.$listValue = $listValue;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        RedisCoroutinesCommands<String, String> redisCoroutinesCommands = LettuceRedisClient.INSTANCE.getCommands();
                        long l = this.$listIndex;
                        String string = this.$listValue;
                        if (string == null) {
                            string = "";
                        }
                        this.label = 1;
                        Object object2 = redisCoroutinesCommands.lset((Object)this.$listKey, l, (Object)string, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    static {
        String[] stringArray = new String[]{"set entry with index %number% in redis (list|array) %string% to %string%"};
        Skript.registerEffect(EffSetRedisListValue.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bypixel/skredis/skript/elements/effects/EffSetRedisListValue$Companion;", "", "<init>", "()V", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

