/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.events.CustomRedisMessageEvent;
import dev.bypixel.skredis.events.RedisMessageEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Redis Message Event - get redis channel")
@Description(value={"Returns the channel name of the Redis message event.", "This can only be used in the Redis Message Event."})
@Examples(value={"on redis message:", "\tset {_channel} to redis channel", "\tbroadcast \"Got message from channel %{_channel}%\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J;\u0010\u0007\u001a\u00020\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0094\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprChannel;", "Lch/njol/skript/lang/util/SimpleExpression;", "", "<init>", "()V", "isSingle", "", "init", "exprs", "", "Lch/njol/skript/lang/Expression;", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "get", "e", "Lorg/bukkit/event/Event;", "(Lorg/bukkit/event/Event;)[Ljava/lang/String;", "getReturnType", "Ljava/lang/Class;", "toString", "event", "b", "Companion", "SkRedis"})
public final class ExprChannel
extends SimpleExpression<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isSingle() {
        return true;
    }

    public boolean init(@NotNull Expression<?>[] exprs, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(exprs, (String)"exprs");
        if (!this.getParser().isCurrentEvent(RedisMessageEvent.class) && !this.getParser().isCurrentEvent(CustomRedisMessageEvent.class)) {
            Skript.error((String)"Cannot use 'redis channel' outside of a redis message event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    @Nullable
    protected String[] get(@Nullable Event e) {
        String[] stringArray;
        Event event = e;
        if (event instanceof RedisMessageEvent) {
            String[] stringArray2 = new String[]{((RedisMessageEvent)e).getChannelName()};
            stringArray = stringArray2;
        } else if (event instanceof CustomRedisMessageEvent) {
            String[] stringArray3 = new String[]{((CustomRedisMessageEvent)e).getChannelName()};
            stringArray = stringArray3;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "redis channel";
    }

    static {
        String[] stringArray = new String[]{"redis channel"};
        Skript.registerExpression(ExprChannel.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprChannel$Companion;", "", "<init>", "()V", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

