/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.lettuce.LettuceRedisClient;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Redis Hashes - get field names by value")
@Description(value={"Returns all field names of a hash stored in Redis that have the given value."})
@Examples(value={"set {_fields::*} to all field names of redis hash \"myHash\" with value \"myValue\"", "loop {_fields::*}:", "\tbroadcast \"Field: %loop-value%\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J;\u0010\n\u001a\u00020\t2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0094\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprGetHashFieldNamesByValue;", "Lch/njol/skript/lang/util/SimpleExpression;", "", "<init>", "()V", "hashKey", "Lch/njol/skript/lang/Expression;", "value", "isSingle", "", "init", "exprs", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "get", "e", "Lorg/bukkit/event/Event;", "(Lorg/bukkit/event/Event;)[Ljava/lang/String;", "getReturnType", "Ljava/lang/Class;", "toString", "event", "b", "Companion", "SkRedis"})
@SourceDebugExtension(value={"SMAP\nExprGetHashFieldNamesByValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExprGetHashFieldNamesByValue.kt\ndev/bypixel/skredis/skript/elements/expressions/ExprGetHashFieldNamesByValue\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,73:1\n504#2,7:74\n37#3,2:81\n37#3,2:83\n*S KotlinDebug\n*F\n+ 1 ExprGetHashFieldNamesByValue.kt\ndev/bypixel/skredis/skript/elements/expressions/ExprGetHashFieldNamesByValue\n*L\n60#1:74,7\n60#1:81,2\n62#1:83,2\n*E\n"})
public final class ExprGetHashFieldNamesByValue
extends SimpleExpression<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Expression<String> hashKey;
    @Nullable
    private Expression<String> value;

    public boolean isSingle() {
        return false;
    }

    public boolean init(@NotNull Expression<?>[] exprs, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(exprs, (String)"exprs");
        Expression<?> expression = exprs[0];
        if (expression == null) {
            return false;
        }
        this.hashKey = expression;
        Expression<?> expression2 = exprs[1];
        if (expression2 == null) {
            return false;
        }
        this.value = expression2;
        return true;
    }

    @Nullable
    protected String[] get(@Nullable Event e) {
        String[] stringArray;
        String value;
        Expression<String> expression = this.hashKey;
        String hash = expression != null ? (String)expression.getSingle(e) : null;
        Expression<String> expression2 = this.value;
        String string = value = expression2 != null ? (String)expression2.getSingle(e) : null;
        if (hash == null || value == null) {
            return null;
        }
        Map map = LettuceRedisClient.INSTANCE.getSync().hgetall((Object)hash);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"hgetall(...)");
        Map $this$filterValues$iv = map;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)value)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Collection $this$toTypedArray$iv = ((Map)result$iv).keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] fieldNames = thisCollection$iv.toArray(new String[0]);
        if (fieldNames[0] != null) {
            $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])fieldNames);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "all field names of redis hash " + this.hashKey;
    }

    static {
        String[] stringArray = new String[]{"name[s] of field with value %string% in redis (hash|value) %string%"};
        Skript.registerExpression(ExprGetHashFieldNamesByValue.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprGetHashFieldNamesByValue$Companion;", "", "<init>", "()V", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

