/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.Main;
import dev.bypixel.skredis.lettuce.LettuceRedisClient;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Redis Hashes - get value of field in redis hash")
@Description(value={"Returns the value of a field stored in a hash that is stored Redis."})
@Examples(value={"set {_value} to value of field \"myField\" in redis hash \"myHash\"", "broadcast \"Value: %{_value}%\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J;\u0010\n\u001a\u00020\t2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0094\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprGetValueOfFieldInHash;", "Lch/njol/skript/lang/util/SimpleExpression;", "", "<init>", "()V", "fieldName", "Lch/njol/skript/lang/Expression;", "hashKey", "isSingle", "", "init", "exprs", "", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "get", "e", "Lorg/bukkit/event/Event;", "(Lorg/bukkit/event/Event;)[Ljava/lang/String;", "getReturnType", "Ljava/lang/Class;", "toString", "event", "b", "Companion", "SkRedis"})
public final class ExprGetValueOfFieldInHash
extends SimpleExpression<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Expression<String> fieldName;
    @Nullable
    private Expression<String> hashKey;

    public boolean isSingle() {
        return true;
    }

    public boolean init(@NotNull Expression<?>[] exprs, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(exprs, (String)"exprs");
        Expression<?> expression = exprs[0];
        if (expression == null) {
            return false;
        }
        this.fieldName = expression;
        Expression<?> expression2 = exprs[1];
        if (expression2 == null) {
            return false;
        }
        this.hashKey = expression2;
        return true;
    }

    @Nullable
    protected String[] get(@Nullable Event e) {
        String[] stringArray;
        String fieldName;
        Main plugin = Main.Companion.getInstance();
        Expression<String> expression = this.hashKey;
        String hashName = expression != null ? (String)expression.getSingle(e) : null;
        Expression<String> expression2 = this.fieldName;
        String string = fieldName = expression2 != null ? (String)expression2.getSingle(e) : null;
        if (hashName == null || fieldName == null) {
            return null;
        }
        String hashValue = (String)LettuceRedisClient.INSTANCE.getSync().hget((Object)hashName, (Object)fieldName);
        if (hashValue != null) {
            String[] stringArray2 = new String[]{hashValue};
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "value of field " + this.fieldName + " in redis hash " + this.hashKey;
    }

    static {
        String[] stringArray = new String[]{"value of field %string% in redis (hash|value) %string%"};
        Skript.registerExpression(ExprGetValueOfFieldInHash.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprGetValueOfFieldInHash$Companion;", "", "<init>", "()V", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

