/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.events.RedisMessageEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Redis Message event - message date")
@Description(value={"Returns the date of the Redis message event as unix timestamp.", "This can only be used in the Redis Message Event."})
@Examples(value={"on redis message:", "\tset {_date} to redis message date", "\tbroadcast \"Got message from channel %{_channel}% at %{_date}%\""})
@Since(value={"1.0.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J;\u0010\u0007\u001a\u00020\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0094\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprMessageDate;", "Lch/njol/skript/lang/util/SimpleExpression;", "", "<init>", "()V", "isSingle", "", "init", "exprs", "", "Lch/njol/skript/lang/Expression;", "matchedPattern", "", "isDelayed", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;)Z", "get", "e", "Lorg/bukkit/event/Event;", "(Lorg/bukkit/event/Event;)[Ljava/lang/String;", "getReturnType", "Ljava/lang/Class;", "toString", "event", "b", "Companion", "SkRedis"})
@SourceDebugExtension(value={"SMAP\nExprMessageDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExprMessageDate.kt\ndev/bypixel/skredis/skript/elements/expressions/ExprMessageDate\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,69:1\n11561#2:70\n11896#2,3:71\n37#3,2:74\n*S KotlinDebug\n*F\n+ 1 ExprMessageDate.kt\ndev/bypixel/skredis/skript/elements/expressions/ExprMessageDate\n*L\n56#1:70\n56#1:71,3\n56#1:74,2\n*E\n"})
public final class ExprMessageDate
extends SimpleExpression<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isSingle() {
        return true;
    }

    public boolean init(@NotNull Expression<?>[] exprs, int matchedPattern, @Nullable Kleenean isDelayed, @Nullable SkriptParser.ParseResult parseResult) {
        Intrinsics.checkNotNullParameter(exprs, (String)"exprs");
        if (!this.getParser().isCurrentEvent(RedisMessageEvent.class)) {
            Skript.error((String)"Cannot use 'redis message date' outside of a redis message event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String[] get(@Nullable Event e) {
        if (e instanceof RedisMessageEvent) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            long date = ((RedisMessageEvent)e).getDate();
            Date[] dateArray = new Date[]{new Date(date)};
            Object $this$map$iv = dateArray;
            boolean $i$f$map = false;
            Date[] dateArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Date[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }
        return null;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "redis message date";
    }

    static {
        String[] stringArray = new String[]{"redis message (date|timestamp|unix|time|unixtime|unix time)"};
        Skript.registerExpression(ExprMessageDate.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bypixel/skredis/skript/elements/expressions/ExprMessageDate$Companion;", "", "<init>", "()V", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

