/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.skript.elements.section;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import dev.bypixel.skredis.Main;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Async Operations - run async")
@Description(value={"Runs the following code asynchronously on another thread. Useful for long-running operations."})
@Examples(value={"\ncommand /test1:\n    trigger:\n        loop all items:\n            set field \"%loop-value%\" to \"test\" in redis hash \"testHash\"\n\ncommand /test2:\n    trigger:\n        loop all items:\n            run async:\n                broadcast value of field \"%loop-value%\" in redis hash \"testHash\"\n"})
@Since(value={"1.2.0"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0010\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/bypixel/skredis/skript/elements/section/SecRunAsync;", "Lch/njol/skript/lang/EffectSection;", "<init>", "()V", "next", "Lch/njol/skript/lang/TriggerItem;", "init", "", "args", "", "Lch/njol/skript/lang/Expression;", "matchedPattern", "", "kleenean", "Lch/njol/util/Kleenean;", "parseResult", "Lch/njol/skript/lang/SkriptParser$ParseResult;", "node", "Lch/njol/skript/config/SectionNode;", "triggerItems", "", "([Lch/njol/skript/lang/Expression;ILch/njol/util/Kleenean;Lch/njol/skript/lang/SkriptParser$ParseResult;Lch/njol/skript/config/SectionNode;Ljava/util/List;)Z", "walk", "e", "Lorg/bukkit/event/Event;", "walkSectionWithCancelCheck", "", "invokeWalk", "item", "event", "toString", "", "debug", "Companion", "SkRedis"})
public final class SecRunAsync
extends EffectSection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TriggerItem next;
    @NotNull
    private static final Set<Event> cancelMap = new LinkedHashSet();

    public boolean init(@Nullable Expression<?>[] args, int matchedPattern, @Nullable Kleenean kleenean, @Nullable SkriptParser.ParseResult parseResult, @Nullable SectionNode node, @Nullable List<? extends TriggerItem> triggerItems) {
        this.next = this.last;
        this.loadCode(node);
        return true;
    }

    @Nullable
    protected TriggerItem walk(@Nullable Event e) {
        if (e == null) {
            return null;
        }
        AtomicReference<Object> localVars = new AtomicReference<Object>(Variables.copyLocalVariables((Event)e));
        Main.Companion.getInstance().getScheduler().runTaskAsynchronously(() -> SecRunAsync.walk$lambda$0(e, localVars, this));
        return this.next;
    }

    private final void walkSectionWithCancelCheck(Event e) {
        TriggerItem current = this.first;
        while (current != null && !Companion.isCancelled(e)) {
            current = this.invokeWalk(current, e);
        }
    }

    private final TriggerItem invokeWalk(TriggerItem item, Event event) {
        Object object = new Class[]{Event.class};
        Method method = TriggerItem.class.getDeclaredMethod("walk", (Class<?>)object);
        method.setAccessible(true);
        Object[] objectArray = new Object[]{event};
        object = method.invoke((Object)item, objectArray);
        return object instanceof TriggerItem ? (TriggerItem)object : null;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "run async";
    }

    private static final void walk$lambda$0(Event $e, AtomicReference $localVars, SecRunAsync this$0) {
        Variables.setLocalVariables((Event)$e, $localVars.get());
        this$0.walkSectionWithCancelCheck($e);
        Companion.clear($e);
    }

    static {
        String[] stringArray = new String[]{"run [redis] async"};
        Skript.registerSection(SecRunAsync.class, (String[])stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/bypixel/skredis/skript/elements/section/SecRunAsync$Companion;", "", "<init>", "()V", "cancelMap", "", "Lorg/bukkit/event/Event;", "cancel", "", "event", "isCancelled", "", "clear", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public final void cancel(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            cancelMap.add(event);
        }

        public final boolean isCancelled(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return cancelMap.contains(event);
        }

        public final void clear(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            cancelMap.remove(event);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

