/*
 * Decompiled with CFR 0.152.
 */
package dev.bypixel.skredis.utils;

import ch.njol.skript.util.Version;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.bypixel.skredis.Main;
import dev.bypixel.skredis.SkRedisLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/bypixel/skredis/utils/UpdateChecker;", "Lorg/bukkit/event/Listener;", "plugin", "Ldev/bypixel/skredis/Main;", "<init>", "(Ldev/bypixel/skredis/Main;)V", "getUpdateVersion", "Ljava/util/concurrent/CompletableFuture;", "Lch/njol/skript/util/Version;", "currentVersion", "", "Companion", "SkRedis"})
public final class UpdateChecker
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Main plugin;
    @Nullable
    private static Version UPDATE_VERSION;

    public UpdateChecker(@NotNull Main plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final CompletableFuture<Version> getUpdateVersion(@NotNull String currentVersion) {
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        CompletableFuture<Version> future = new CompletableFuture<Version>();
        Object object = UPDATE_VERSION != null ? Boolean.valueOf(future.complete(UPDATE_VERSION)) : Main.Companion.getInstance().getScheduler().runTaskAsynchronously(() -> UpdateChecker.getUpdateVersion$lambda$0(currentVersion, future));
        return future;
    }

    private static final void getUpdateVersion$lambda$0(String $currentVersion, CompletableFuture $future) {
        Companion.getLatestReleaseVersion(arg_0 -> UpdateChecker.getUpdateVersion$lambda$0$0($currentVersion, $future, arg_0));
    }

    private static final void getUpdateVersion$lambda$0$0(String $currentVersion, CompletableFuture $future, String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Version plugVer = new Version($currentVersion);
        Version curVer = new Version(version);
        if (curVer.compareTo(plugVer) <= 0) {
            v0 = $future.cancel(true);
        } else {
            UPDATE_VERSION = curVer;
            v0 = $future.complete(UPDATE_VERSION);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/bypixel/skredis/utils/UpdateChecker$Companion;", "", "<init>", "()V", "UPDATE_VERSION", "Lch/njol/skript/util/Version;", "checkForUpdate", "", "pluginVersion", "", "getLatestReleaseVersion", "consumer", "Ljava/util/function/Consumer;", "SkRedis"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkForUpdate(@NotNull String pluginVersion) {
            Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
            MiniMessage miniMessage = MiniMessage.miniMessage();
            Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
            MiniMessage miniMessages = miniMessage;
            SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), "Checking for updates...");
            this.getLatestReleaseVersion(arg_0 -> Companion.checkForUpdate$lambda$0(pluginVersion, arg_0));
        }

        public final void getLatestReleaseVersion(@NotNull Consumer<String> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            MiniMessage miniMessage = MiniMessage.miniMessage();
            Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
            MiniMessage miniMessages = miniMessage;
            try {
                String tagName;
                URI uri = new URI("https://api.github.com/repos/byPixelTV/SkRedis/releases/latest");
                URL url = uri.toURL();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                JsonObject jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                String string = tagName = jsonObject.get("tag_name").getAsString();
                Intrinsics.checkNotNull((Object)string);
                tagName = StringsKt.removePrefix((String)string, (CharSequence)"v");
                consumer.accept(tagName);
            }
            catch (IOException e) {
                SkRedisLogger.INSTANCE.error((Plugin)Main.Companion.getInstance(), "An error occurred while checking for updates: " + e.getMessage());
            }
        }

        private static final void checkForUpdate$lambda$0(String $pluginVersion, String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Version plugVer = new Version($pluginVersion);
            Version curVer = new Version(version);
            if (curVer.compareTo(plugVer) <= 0) {
                SkRedisLogger.INSTANCE.success((Plugin)Main.Companion.getInstance(), "The plugin is up to date!");
            } else {
                SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), "The plugin is not up to date!");
                SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), " - Current version: v" + $pluginVersion);
                SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), " - Available update: v" + version);
                SkRedisLogger.INSTANCE.info((Plugin)Main.Companion.getInstance(), " - Download available at: <aqua>https://github.com/byPixelTV/SkRedis/releases</aqua>");
                UPDATE_VERSION = curVer;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

