/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBottomBlock;
import net.dragonegg.sculkcatalyticchamber.registry.BlockRegistry;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
public abstract class ChamberBlock<T extends ChamberBlockEntity>
extends Block
implements IBE<T>,
IWrenchable {
    public static final Set<BlockPos> breakPos = new HashSet<BlockPos>();

    public ChamberBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> be.use(worldIn, pos, player, handIn));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.ordinal() == 0 || level.m_8055_(pos.m_6625_(this.ordinal())).m_60734_() instanceof ChamberBottomBlock;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            ChamberBlock.breakMultiblock(state, (LevelAccessor)level, pos, null);
            IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
        }
    }

    public static void breakMultiblock(BlockState state, LevelAccessor level, BlockPos pos, @Nullable Player player) {
        Block block;
        if (!breakPos.contains(pos) && (block = state.m_60734_()) instanceof ChamberBlock) {
            ChamberBlock chamber = (ChamberBlock)block;
            breakPos.add(pos);
            for (int i = 0; i < 3; ++i) {
                BlockPos posI = pos.m_6630_(i - chamber.ordinal());
                BlockState stateI = level.m_8055_(posI);
                if (!(stateI.m_60734_() instanceof ChamberBlock) || breakPos.contains(posI)) continue;
                breakPos.add(posI);
                level.m_46953_(posI, player == null || !player.m_7500_(), (Entity)player);
                breakPos.remove(posI);
            }
            breakPos.remove(pos);
        }
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        for (int i = 0; i < 3; ++i) {
            BlockPos posI = pos.m_6630_(i - this.ordinal());
            BlockState stateI = level.m_8055_(posI);
            if (!(stateI.m_60734_() instanceof ChamberBlock)) continue;
            level.m_46961_(posI, true);
        }
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        for (int i = 0; i < 3; ++i) {
            BlockPos posI = pos.m_6630_(i - this.ordinal());
            BlockState stateI = level.m_8055_(posI);
            Block block = stateI.m_60734_();
            if (block instanceof ChamberBlock) {
                ChamberBlock chamber = (ChamberBlock)block;
                chamber.m_7592_(level, posI, explosion);
            }
            level.m_7731_(posI, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        for (int i = 0; i < 3; ++i) {
            BlockPos posI = pos.m_6630_(i - this.ordinal());
            BlockState stateI = world.m_8055_(posI);
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)stateI, (ServerLevel)serverLevel, (BlockPos)posI, (BlockEntity)world.m_7702_(posI), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
            }
            stateI.m_222967_(serverLevel, posI, ItemStack.f_41583_, true);
            world.m_46961_(posI, false);
        }
        this.playRemoveSound(world, pos);
        return InteractionResult.SUCCESS;
    }

    public static boolean isChamber(LevelReader world, BlockPos pos) {
        return world.m_7702_(pos) instanceof ChamberBlockEntity;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return BlockRegistry.CHAMBER_BOTTOM_BLOCK.asStack();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(ChamberBlockEntity::getInputInventory).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    public abstract int ordinal();
}

