/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBottomBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberInventory;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberMiddleBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberOperatingBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberTopBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ChamberBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public ChamberInventory inputInventory = new ChamberInventory(9, this);
    public SmartFluidTankBehaviour inputTank;
    protected boolean contentsChanged;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected LazyOptional<IFluidHandler> fluidCapability;
    int recipeBackupCheck;

    public ChamberBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.contentsChanged = true;
        this.recipeBackupCheck = 20;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 8000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        behaviours.add((BlockEntityBehaviour)this.inputTank);
    }

    protected void setCapabilities() {
        this.itemCapability = LazyOptional.of(this::getInvs);
        this.fluidCapability = LazyOptional.of(this::getTanks);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
    }

    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void onEmptied() {
        this.getOperator().ifPresent(be -> {
            be.chamberRemoved = true;
        });
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
    }

    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void notifyUpdate() {
        super.notifyUpdate();
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_) {
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
        }
    }

    public void scheduleChangeOfContents() {
        if (!this.contentsChanged) {
            return;
        }
        this.contentsChanged = false;
        this.getOperator().ifPresent(be -> be.chamberChecker.scheduleUpdate());
    }

    public boolean canContinueProcessing() {
        ChamberBottomBlockEntity bottom = this.getBottom();
        return bottom != null && bottom.isBufferEmpty();
    }

    public abstract Optional<ChamberOperatingBlockEntity> getOperator();

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public boolean isEmpty() {
        return this.inputInventory.m_7983_() && this.inputTank.isEmpty();
    }

    public FilteringBehaviour getFilter() {
        ChamberBottomBlockEntity bottom = this.getBottom();
        return bottom != null ? bottom.filtering : null;
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    public IItemHandlerModifiable getInvs() {
        return this.inputInventory;
    }

    public IFluidHandler getTanks() {
        return (IFluidHandler)this.inputTank.getCapability().orElse(null);
    }

    public abstract ChamberTopBlockEntity getTop();

    public abstract ChamberMiddleBlockEntity getMiddle();

    public abstract ChamberBottomBlockEntity getBottom();

    protected abstract NonNullList<Ingredient> ingredients(Recipe<?> var1);

    protected InteractionResult use(Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack heldItem = player.m_21120_(handIn);
        SmartInventory inv = this.getInputInventory();
        if (!heldItem.m_41619_()) {
            boolean canInsert;
            if (FluidHelper.tryEmptyItemIntoBE((Level)worldIn, (Player)player, (InteractionHand)handIn, (ItemStack)heldItem, (SmartBlockEntity)this)) {
                return InteractionResult.SUCCESS;
            }
            if (FluidHelper.tryFillItemFromBE((Level)worldIn, (Player)player, (InteractionHand)handIn, (ItemStack)heldItem, (SmartBlockEntity)this)) {
                return InteractionResult.SUCCESS;
            }
            if (GenericItemEmptying.canItemBeEmptied((Level)worldIn, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)worldIn, (ItemStack)heldItem)) {
                return InteractionResult.SUCCESS;
            }
            boolean bl = canInsert = !(heldItem.m_41720_() instanceof WrenchItem);
            if (this.getOperator().isPresent()) {
                ChamberOperatingBlockEntity operator = this.getOperator().get();
                canInsert = operator.getAllRecipes().stream().map(this::ingredients).flatMap(Collection::stream).anyMatch(ingredient -> ingredient.test(heldItem));
            }
            if (canInsert) {
                for (int slot = 0; slot < inv.getSlots(); ++slot) {
                    ItemStack remain = inv.insertItem(slot, heldItem, false);
                    if (remain.m_41613_() == heldItem.m_41613_()) continue;
                    player.m_21008_(handIn, remain);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (this.emptyInv(inv, player)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean emptyInv(SmartInventory inv, Player player) {
        boolean success = false;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            if (stackInSlot.m_41619_()) continue;
            player.m_150109_().m_150079_(stackInSlot);
            inv.setStackInSlot(slot, ItemStack.f_41583_);
            success = true;
        }
        this.onEmptied();
        return success;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.builder((String)"sculkcatalyticchamber").translate("gui.goggles.chamber_contents", new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            Lang.text((String)"").add(Components.translatable((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(Lang.text((String)(" x" + stackInSlot.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.text((String)"").add(Lang.fluidName((FluidStack)fluidStack).add(Lang.text((String)" ")).style(ChatFormatting.GRAY).add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }
}

