/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.shrieker;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.dragonegg.sculkcatalyticchamber.content.shrieker.MechanicalShriekerParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MechanicalShriekerParticle
extends TextureSheetParticle {
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private int delay;
    private final Vec3i normal;

    protected MechanicalShriekerParticle(ClientLevel pLevel, double pX, double pY, double pZ, int delay, Direction direction) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.f_107663_ = 0.85f;
        this.delay = delay;
        this.f_107225_ = 90;
        this.f_107226_ = 0.0f;
        this.f_107219_ = false;
        this.normal = direction.m_122436_();
        this.f_107215_ = (double)this.normal.m_123341_() * 0.1;
        this.f_107216_ = (double)this.normal.m_123342_() * 0.1;
        this.f_107217_ = (double)this.normal.m_123343_() * 0.1;
    }

    public float m_5902_(float pScaleFactor) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + pScaleFactor) * 2.0f / 45.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        if (this.delay <= 0) {
            this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + pPartialTicks) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
            this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, quad -> quad.mul((Quaternionfc)new Quaternionf().rotateXYZ(-1.5707964f * (float)(this.normal.m_123341_() - 1), 0.0f, -1.5707964f * (float)this.normal.m_123343_())));
            this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, quad -> quad.mul((Quaternionfc)new Quaternionf().rotateXYZ(1.5707964f * (float)(this.normal.m_123341_() + 1), (float)(-Math.PI), 1.5707964f * (float)this.normal.m_123343_())));
        }
    }

    private void renderRotatedParticle(VertexConsumer pConsumer, Camera pCamera, float pPartialTick, Consumer<Quaternionf> pQuaternion) {
        Vec3 vec3 = pCamera.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
        pQuaternion.accept(quaternionf);
        quaternionf.transform(TRANSFORM_VECTOR);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(pPartialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        int j = this.m_6355_(pPartialTick);
        this.makeCornerVertex(pConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
    }

    private void makeCornerVertex(VertexConsumer pConsumer, Vector3f pVertex, float pU, float pV, int pPackedLight) {
        pConsumer.m_5483_((double)pVertex.x(), (double)pVertex.y(), (double)pVertex.z()).m_7421_(pU, pV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(pPackedLight).m_5752_();
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    public void m_5989_() {
        if (this.delay > 0) {
            --this.delay;
        } else {
            super.m_5989_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<MechanicalShriekerParticleData> {
        private final SpriteSet sprite;

        public Factory(SpriteSet pSprite) {
            this.sprite = pSprite;
        }

        public Particle createParticle(MechanicalShriekerParticleData pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            MechanicalShriekerParticle particle = new MechanicalShriekerParticle(pLevel, pX, pY, pZ, pType.getDelay(), pType.getDirection());
            particle.m_108335_(this.sprite);
            particle.m_107271_(1.0f);
            return particle;
        }
    }
}

