/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.registry;

import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import java.util.function.Function;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class ArmInteractionPointTypeRegistry {
    public static final ChamberType CHAMBER = ArmInteractionPointTypeRegistry.register("chamber", ChamberType::new);

    private static <T extends ArmInteractionPointType> T register(String id, Function<ResourceLocation, T> factory) {
        ArmInteractionPointType type = (ArmInteractionPointType)factory.apply(Create.asResource((String)id));
        ArmInteractionPointType.register((ArmInteractionPointType)type);
        return (T)type;
    }

    public static void register() {
    }

    public static class ChamberType
    extends ArmInteractionPointType {
        public ChamberType(ResourceLocation id) {
            super(id);
        }

        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return ChamberBlock.isChamber((LevelReader)level, pos);
        }

        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint((ArmInteractionPointType)this, level, pos, state);
        }
    }
}

