/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.data.SimpleDatagenIngredient;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.DataIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Pair;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipe;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipeSerializer;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.fluids.FluidStack;

public class ChamberRecipeBuilder {
    protected ChamberRecipeParams params;
    protected List<ICondition> recipeConditions;

    public ChamberRecipeBuilder(ResourceLocation recipeId) {
        this.params = new ChamberRecipeParams(recipeId);
        this.recipeConditions = new ArrayList<ICondition>();
    }

    public ChamberRecipeBuilder withItemTopIngredients(Ingredient ... ingredients) {
        return this.withItemTopIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public ChamberRecipeBuilder withItemTopIngredients(NonNullList<Ingredient> ingredients) {
        this.params.topIngredients = ingredients;
        return this;
    }

    public ChamberRecipeBuilder withFluidTopIngredients(FluidIngredient ... ingredients) {
        return this.withFluidTopIngredients((NonNullList<FluidIngredient>)NonNullList.m_122783_((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ChamberRecipeBuilder withFluidTopIngredients(NonNullList<FluidIngredient> ingredients) {
        this.params.topFluidIngredients = ingredients;
        return this;
    }

    public ChamberRecipeBuilder withItemBottomIngredients(Ingredient ... ingredients) {
        return this.withItemBottomIngredients((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public ChamberRecipeBuilder withItemBottomIngredients(NonNullList<Ingredient> ingredients) {
        this.params.bottomIngredients = ingredients;
        return this;
    }

    public ChamberRecipeBuilder withFluidBottomIngredients(FluidIngredient ... ingredients) {
        return this.withFluidBottomIngredients((NonNullList<FluidIngredient>)NonNullList.m_122783_((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ChamberRecipeBuilder withFluidBottomIngredients(NonNullList<FluidIngredient> ingredients) {
        this.params.bottomFluidIngredients = ingredients;
        return this;
    }

    public ChamberRecipeBuilder withItemCatalysts(Ingredient ... ingredients) {
        return this.withItemCatalysts((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
    }

    public ChamberRecipeBuilder withItemCatalysts(NonNullList<Ingredient> ingredients) {
        this.params.catalysts = ingredients;
        return this;
    }

    public ChamberRecipeBuilder withFluidCatalysts(FluidIngredient ... ingredients) {
        return this.withFluidCatalysts((NonNullList<FluidIngredient>)NonNullList.m_122783_((Object)FluidIngredient.EMPTY, (Object[])ingredients));
    }

    public ChamberRecipeBuilder withFluidCatalysts(NonNullList<FluidIngredient> ingredients) {
        this.params.fluidCatalysts = ingredients;
        return this;
    }

    public ChamberRecipeBuilder neverConsumed() {
        return this.withChances(0.0);
    }

    public ChamberRecipeBuilder alwaysConsumed() {
        return this.withChances(1.0);
    }

    public ChamberRecipeBuilder withChances(double chances) {
        this.params.chances = chances;
        return this;
    }

    public ChamberRecipeBuilder withSingleItemOutput(ItemStack output) {
        return this.withItemOutputs(new ProcessingOutput(output, 1.0f));
    }

    public ChamberRecipeBuilder withItemOutputs(ProcessingOutput ... outputs) {
        return this.withItemOutputs((NonNullList<ProcessingOutput>)NonNullList.m_122783_((Object)ProcessingOutput.EMPTY, (Object[])outputs));
    }

    public ChamberRecipeBuilder withItemOutputs(NonNullList<ProcessingOutput> outputs) {
        this.params.results = outputs;
        return this;
    }

    public ChamberRecipeBuilder withFluidOutputs(FluidStack ... outputs) {
        return this.withFluidOutputs((NonNullList<FluidStack>)NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])outputs));
    }

    public ChamberRecipeBuilder withFluidOutputs(NonNullList<FluidStack> outputs) {
        this.params.fluidResults = outputs;
        return this;
    }

    public ChamberRecipeBuilder requiresHeat(HeatCondition condition) {
        this.params.requiredHeat = condition;
        return this;
    }

    public ChamberRecipe build() {
        return new ChamberRecipe(this.params);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult(this.build(), this.recipeConditions));
    }

    public ChamberRecipeBuilder topRequire(TagKey<Item> tag) {
        return this.topRequire(Ingredient.m_204132_(tag));
    }

    public ChamberRecipeBuilder topRequire(ItemLike item) {
        return this.topRequire(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ChamberRecipeBuilder topRequire(Ingredient ingredient) {
        this.params.topIngredients.add((Object)ingredient);
        return this;
    }

    public ChamberRecipeBuilder topRequire(Mods mod, String id) {
        this.params.topIngredients.add((Object)new SimpleDatagenIngredient(mod, id));
        return this;
    }

    public ChamberRecipeBuilder topRequire(ResourceLocation ingredient) {
        this.params.topIngredients.add((Object)DataIngredient.ingredient(null, (ResourceLocation)ingredient, (ItemPredicate[])new ItemPredicate[0]));
        return this;
    }

    public ChamberRecipeBuilder topRequire(Fluid fluid, int amount) {
        return this.topRequire(FluidIngredient.fromFluid((Fluid)fluid, (int)amount));
    }

    public ChamberRecipeBuilder topRequire(TagKey<Fluid> fluidTag, int amount) {
        return this.topRequire(FluidIngredient.fromTag(fluidTag, (int)amount));
    }

    public ChamberRecipeBuilder topRequire(FluidIngredient ingredient) {
        this.params.topFluidIngredients.add((Object)ingredient);
        return this;
    }

    public ChamberRecipeBuilder bottomRequire(TagKey<Item> tag) {
        return this.bottomRequire(Ingredient.m_204132_(tag));
    }

    public ChamberRecipeBuilder bottomRequire(ItemLike item) {
        return this.bottomRequire(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ChamberRecipeBuilder bottomRequire(Ingredient ingredient) {
        this.params.bottomIngredients.add((Object)ingredient);
        return this;
    }

    public ChamberRecipeBuilder bottomRequire(Mods mod, String id) {
        this.params.bottomIngredients.add((Object)new SimpleDatagenIngredient(mod, id));
        return this;
    }

    public ChamberRecipeBuilder bottomRequire(ResourceLocation ingredient) {
        this.params.bottomIngredients.add((Object)DataIngredient.ingredient(null, (ResourceLocation)ingredient, (ItemPredicate[])new ItemPredicate[0]));
        return this;
    }

    public ChamberRecipeBuilder bottomRequire(Fluid fluid, int amount) {
        return this.bottomRequire(FluidIngredient.fromFluid((Fluid)fluid, (int)amount));
    }

    public ChamberRecipeBuilder bottomRequire(TagKey<Fluid> fluidTag, int amount) {
        return this.bottomRequire(FluidIngredient.fromTag(fluidTag, (int)amount));
    }

    public ChamberRecipeBuilder bottomRequire(FluidIngredient ingredient) {
        this.params.bottomFluidIngredients.add((Object)ingredient);
        return this;
    }

    public ChamberRecipeBuilder catalysts(TagKey<Item> tag) {
        return this.catalysts(Ingredient.m_204132_(tag));
    }

    public ChamberRecipeBuilder catalysts(ItemLike item) {
        return this.catalysts(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ChamberRecipeBuilder catalysts(Ingredient ingredient) {
        this.params.catalysts.add((Object)ingredient);
        return this;
    }

    public ChamberRecipeBuilder catalysts(Mods mod, String id) {
        this.params.catalysts.add((Object)new SimpleDatagenIngredient(mod, id));
        return this;
    }

    public ChamberRecipeBuilder catalysts(ResourceLocation ingredient) {
        this.params.catalysts.add((Object)DataIngredient.ingredient(null, (ResourceLocation)ingredient, (ItemPredicate[])new ItemPredicate[0]));
        return this;
    }

    public ChamberRecipeBuilder catalysts(Fluid fluid, int amount) {
        return this.catalysts(FluidIngredient.fromFluid((Fluid)fluid, (int)amount));
    }

    public ChamberRecipeBuilder catalysts(TagKey<Fluid> fluidTag, int amount) {
        return this.catalysts(FluidIngredient.fromTag(fluidTag, (int)amount));
    }

    public ChamberRecipeBuilder catalysts(FluidIngredient ingredient) {
        this.params.fluidCatalysts.add((Object)ingredient);
        return this;
    }

    public ChamberRecipeBuilder output(ItemLike item) {
        return this.output(item, 1);
    }

    public ChamberRecipeBuilder output(float chance, ItemLike item) {
        return this.output(chance, item, 1);
    }

    public ChamberRecipeBuilder output(ItemLike item, int amount) {
        return this.output(1.0f, item, amount);
    }

    public ChamberRecipeBuilder output(float chance, ItemLike item, int amount) {
        return this.output(chance, new ItemStack(item, amount));
    }

    public ChamberRecipeBuilder output(ItemStack output) {
        return this.output(1.0f, output);
    }

    public ChamberRecipeBuilder output(float chance, ItemStack output) {
        return this.output(new ProcessingOutput(output, chance));
    }

    public ChamberRecipeBuilder output(float chance, Mods mod, String id, int amount) {
        return this.output(new ProcessingOutput(Pair.of((Object)mod.asResource(id), (Object)amount), chance));
    }

    public ChamberRecipeBuilder output(Mods mod, String id) {
        return this.output(1.0f, mod.asResource(id), 1);
    }

    public ChamberRecipeBuilder output(float chance, ResourceLocation registryName, int amount) {
        return this.output(new ProcessingOutput(Pair.of((Object)registryName, (Object)amount), chance));
    }

    public ChamberRecipeBuilder output(ProcessingOutput output) {
        this.params.results.add((Object)output);
        return this;
    }

    public ChamberRecipeBuilder output(Fluid fluid, int amount) {
        fluid = FluidHelper.convertToStill((Fluid)fluid);
        return this.output(new FluidStack(fluid, amount));
    }

    public ChamberRecipeBuilder output(FluidStack fluidStack) {
        this.params.fluidResults.add((Object)fluidStack);
        return this;
    }

    public ChamberRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public ChamberRecipeBuilder whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public ChamberRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    public static class ChamberRecipeParams {
        protected ResourceLocation id;
        protected NonNullList<Ingredient> topIngredients;
        protected NonNullList<FluidIngredient> topFluidIngredients;
        protected NonNullList<Ingredient> bottomIngredients;
        protected NonNullList<FluidIngredient> bottomFluidIngredients;
        protected NonNullList<Ingredient> catalysts;
        protected NonNullList<FluidIngredient> fluidCatalysts;
        protected double chances;
        protected NonNullList<ProcessingOutput> results;
        protected NonNullList<FluidStack> fluidResults;
        protected HeatCondition requiredHeat;

        protected ChamberRecipeParams(ResourceLocation id) {
            this.id = id;
            this.topIngredients = NonNullList.m_122779_();
            this.topFluidIngredients = NonNullList.m_122779_();
            this.bottomIngredients = NonNullList.m_122779_();
            this.bottomFluidIngredients = NonNullList.m_122779_();
            this.catalysts = NonNullList.m_122779_();
            this.fluidCatalysts = NonNullList.m_122779_();
            this.chances = 0.0;
            this.results = NonNullList.m_122779_();
            this.fluidResults = NonNullList.m_122779_();
            this.requiredHeat = HeatCondition.NONE;
        }
    }

    public static class DataGenResult
    implements FinishedRecipe {
        private List<ICondition> recipeConditions;
        private ChamberRecipeSerializer serializer;
        private ResourceLocation id;
        private ChamberRecipe recipe;

        public DataGenResult(ChamberRecipe recipe, List<ICondition> recipeConditions) {
            this.recipe = recipe;
            this.recipeConditions = recipeConditions;
            IRecipeTypeInfo recipeType = this.recipe.getTypeInfo();
            if (!(recipeType.getSerializer() instanceof ChamberRecipeSerializer)) {
                throw new IllegalStateException("Cannot datagen ChamberRecipe");
            }
            this.id = recipe.m_6423_();
            this.serializer = (ChamberRecipeSerializer)recipe.m_7707_();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

