/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipe;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipeBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

public class ChamberRecipeSerializer
implements RecipeSerializer<ChamberRecipe> {
    public final void write(JsonObject json, ChamberRecipe recipe) {
        HeatCondition requiredHeat;
        JsonArray jsonTopIngredients = new JsonArray();
        JsonArray jsonBottomIngredients = new JsonArray();
        JsonArray jsonCatalysts = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        recipe.topIngredients.forEach(i -> jsonTopIngredients.add(i.m_43942_()));
        recipe.topFluidIngredients.forEach(i -> jsonTopIngredients.add((JsonElement)i.serialize()));
        recipe.bottomIngredients.forEach(i -> jsonBottomIngredients.add(i.m_43942_()));
        recipe.bottomFluidIngredients.forEach(i -> jsonBottomIngredients.add((JsonElement)i.serialize()));
        recipe.catalysts.forEach(i -> jsonCatalysts.add(i.m_43942_()));
        recipe.fluidCatalysts.forEach(i -> jsonCatalysts.add((JsonElement)i.serialize()));
        recipe.results.forEach(o -> jsonOutputs.add(o.serialize()));
        recipe.fluidResults.forEach(o -> jsonOutputs.add(FluidHelper.serializeFluidStack((FluidStack)o)));
        json.add("topIngredients", (JsonElement)jsonTopIngredients);
        json.add("bottomIngredients", (JsonElement)jsonBottomIngredients);
        json.add("catalysts", (JsonElement)jsonCatalysts);
        json.add("results", (JsonElement)jsonOutputs);
        double chances = recipe.getChance();
        if (chances > 0.0) {
            json.addProperty("chances", (Number)chances);
        }
        if ((requiredHeat = recipe.getRequiredHeat()) != HeatCondition.NONE) {
            json.addProperty("heatRequirement", requiredHeat.serialize());
        }
    }

    public final ChamberRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        ChamberRecipeBuilder builder = new ChamberRecipeBuilder(recipeId);
        NonNullList topIngredients = NonNullList.m_122779_();
        NonNullList topFluidIngredients = NonNullList.m_122779_();
        NonNullList bottomIngredients = NonNullList.m_122779_();
        NonNullList bottomFluidIngredients = NonNullList.m_122779_();
        NonNullList catalysts = NonNullList.m_122779_();
        NonNullList fluidCatalysts = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        NonNullList fluidResults = NonNullList.m_122779_();
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"topIngredients")) {
            if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                topFluidIngredients.add((Object)FluidIngredient.deserialize((JsonElement)je));
                continue;
            }
            topIngredients.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"bottomIngredients")) {
            if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                bottomFluidIngredients.add((Object)FluidIngredient.deserialize((JsonElement)je));
                continue;
            }
            bottomIngredients.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"catalysts")) {
            if (FluidIngredient.isFluidIngredient((JsonElement)je)) {
                fluidCatalysts.add((Object)FluidIngredient.deserialize((JsonElement)je));
                continue;
            }
            catalysts.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"results")) {
            JsonObject jsonObject = je.getAsJsonObject();
            if (GsonHelper.m_13900_((JsonObject)jsonObject, (String)"fluid")) {
                fluidResults.add((Object)FluidHelper.deserializeFluidStack((JsonObject)jsonObject));
                continue;
            }
            results.add((Object)ProcessingOutput.deserialize((JsonElement)je));
        }
        builder.withItemTopIngredients((NonNullList<Ingredient>)topIngredients).withFluidTopIngredients((NonNullList<FluidIngredient>)topFluidIngredients).withItemBottomIngredients((NonNullList<Ingredient>)bottomIngredients).withFluidBottomIngredients((NonNullList<FluidIngredient>)bottomFluidIngredients).withItemCatalysts((NonNullList<Ingredient>)catalysts).withFluidCatalysts((NonNullList<FluidIngredient>)fluidCatalysts).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidOutputs((NonNullList<FluidStack>)fluidResults);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"chances")) {
            builder.withChances(GsonHelper.m_144784_((JsonObject)json, (String)"chances"));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"heatRequirement")) {
            builder.requiresHeat(HeatCondition.deserialize((String)GsonHelper.m_13906_((JsonObject)json, (String)"heatRequirement")));
        }
        ChamberRecipe recipe = builder.build();
        return recipe;
    }

    public final void toNetwork(FriendlyByteBuf buffer, ChamberRecipe recipe) {
        NonNullList<Ingredient> topIngredients = recipe.topIngredients;
        NonNullList<FluidIngredient> topFluidIngredients = recipe.topFluidIngredients;
        NonNullList<Ingredient> botttomIngredients = recipe.bottomIngredients;
        NonNullList<FluidIngredient> bottomFluidIngredients = recipe.bottomFluidIngredients;
        NonNullList<Ingredient> catalysts = recipe.catalysts;
        NonNullList<FluidIngredient> fluidCatalysts = recipe.fluidCatalysts;
        NonNullList<ProcessingOutput> outputs = recipe.results;
        NonNullList<FluidStack> fluidOutputs = recipe.fluidResults;
        buffer.m_130130_(topIngredients.size());
        topIngredients.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(topFluidIngredients.size());
        topFluidIngredients.forEach(i -> i.write(buffer));
        buffer.m_130130_(botttomIngredients.size());
        botttomIngredients.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(bottomFluidIngredients.size());
        bottomFluidIngredients.forEach(i -> i.write(buffer));
        buffer.m_130130_(catalysts.size());
        catalysts.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(fluidCatalysts.size());
        fluidCatalysts.forEach(i -> i.write(buffer));
        buffer.m_130130_(outputs.size());
        outputs.forEach(o -> o.write(buffer));
        buffer.m_130130_(fluidOutputs.size());
        fluidOutputs.forEach(o -> o.writeToPacket(buffer));
        buffer.writeDouble(recipe.getChance());
        buffer.m_130130_(recipe.getRequiredHeat().ordinal());
    }

    public final ChamberRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i;
        NonNullList topIngredients = NonNullList.m_122779_();
        NonNullList topFluidIngredients = NonNullList.m_122779_();
        NonNullList bottomIngredients = NonNullList.m_122779_();
        NonNullList bottomFluidIngredients = NonNullList.m_122779_();
        NonNullList catalysts = NonNullList.m_122779_();
        NonNullList fluidCatalysts = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        NonNullList fluidResults = NonNullList.m_122779_();
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            topIngredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            topFluidIngredients.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            bottomIngredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            bottomFluidIngredients.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            catalysts.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            fluidCatalysts.add((Object)FluidIngredient.read((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            results.add((Object)ProcessingOutput.read((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            fluidResults.add((Object)FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }
        ChamberRecipe recipe = new ChamberRecipeBuilder(recipeId).withItemTopIngredients((NonNullList<Ingredient>)topIngredients).withFluidTopIngredients((NonNullList<FluidIngredient>)topFluidIngredients).withItemBottomIngredients((NonNullList<Ingredient>)bottomIngredients).withFluidBottomIngredients((NonNullList<FluidIngredient>)bottomFluidIngredients).withItemCatalysts((NonNullList<Ingredient>)catalysts).withFluidCatalysts((NonNullList<FluidIngredient>)fluidCatalysts).withItemOutputs((NonNullList<ProcessingOutput>)results).withFluidOutputs((NonNullList<FluidStack>)fluidResults).withChances(buffer.readDouble()).requiresHeat(HeatCondition.values()[buffer.m_130242_()]).build();
        return recipe;
    }
}

