/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.shrieker;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import java.util.function.Supplier;
import net.dragonegg.sculkcatalyticchamber.content.shrieker.MechanicalShriekerParticle;
import net.dragonegg.sculkcatalyticchamber.registry.ParticleTypeRegistry;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class MechanicalShriekerParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<MechanicalShriekerParticleData> {
    public static final Codec<MechanicalShriekerParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("delay").forGetter(p -> p.delay), (App)Codec.INT.fieldOf("ordinal").forGetter(p -> p.ordinal())).apply((Applicative)i, MechanicalShriekerParticleData::new));
    public static final ParticleOptions.Deserializer<MechanicalShriekerParticleData> DESERIALIZER = new ParticleOptions.Deserializer<MechanicalShriekerParticleData>(){

        public MechanicalShriekerParticleData fromCommand(ParticleType<MechanicalShriekerParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int delay = reader.readInt();
            reader.expect(' ');
            int ordinal = reader.readInt();
            return new MechanicalShriekerParticleData(delay, ordinal);
        }

        public MechanicalShriekerParticleData fromNetwork(ParticleType<MechanicalShriekerParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new MechanicalShriekerParticleData(buffer.readInt(), buffer.readInt());
        }
    };
    public static final Supplier<MechanicalShriekerParticleData> FACTORY = MechanicalShriekerParticleData::new;
    private final int delay;
    private final Direction direction;

    public MechanicalShriekerParticleData(int delay, Direction direction) {
        this.delay = delay;
        this.direction = direction;
    }

    public MechanicalShriekerParticleData(int delay, int ordinal) {
        this(delay, Direction.values()[ordinal]);
    }

    public MechanicalShriekerParticleData() {
        this(0, Direction.UP);
    }

    public int getDelay() {
        return this.delay;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int ordinal() {
        return this.direction.ordinal();
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ParticleTypeRegistry.MECHANICAL_SHRIEKER.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.delay);
        buffer.writeInt(this.ordinal());
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d", "mechanical_shrieker", this.delay, this.ordinal());
    }

    public ParticleOptions.Deserializer<MechanicalShriekerParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<MechanicalShriekerParticleData> getCodec(ParticleType<MechanicalShriekerParticleData> type) {
        return CODEC;
    }

    public ParticleEngine.SpriteParticleRegistration<MechanicalShriekerParticleData> getMetaFactory() {
        return MechanicalShriekerParticle.Factory::new;
    }
}

