/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBottomBlock;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberInventory;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberMiddleBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberOperatingBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipe;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberTopBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ChamberBottomBlockEntity
extends ChamberBlockEntity {
    protected SmartInventory outputInventory = new ChamberInventory(9, this).forbidInsertion();
    protected SmartFluidTankBehaviour outputTank;
    protected FilteringBehaviour filtering;
    private Couple<SmartInventory> invs;
    private Couple<SmartFluidTankBehaviour> tanks;
    List<Direction> disabledSpoutputs;
    Direction preferredSpoutput;
    protected List<ItemStack> spoutputBuffer;
    protected List<FluidStack> spoutputFluidBuffer;
    public static final int OUTPUT_ANIMATION_TIME = 10;
    List<IntAttached<ItemStack>> visualizedOutputItems;
    List<IntAttached<FluidStack>> visualizedOutputFluids;

    public ChamberBottomBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.outputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.invs = Couple.create((Object)((Object)this.inputInventory), (Object)this.outputInventory);
        this.tanks = Couple.create((Object)this.inputTank, (Object)this.outputTank);
        this.setCapabilities();
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.disabledSpoutputs = new ArrayList<Direction>();
        this.preferredSpoutput = null;
        this.spoutputBuffer = new ArrayList<ItemStack>();
        this.spoutputFluidBuffer = new ArrayList<FluidStack>();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new ChamberValueBox()).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 8000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.outputTank);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
        this.preferredSpoutput = null;
        if (compound.m_128441_("PreferredSpoutput")) {
            this.preferredSpoutput = (Direction)NBTHelper.readEnum((CompoundTag)compound, (String)"PreferredSpoutput", Direction.class);
        }
        this.disabledSpoutputs.clear();
        ListTag disabledList = compound.m_128437_("DisabledSpoutput", 8);
        disabledList.forEach(d -> this.disabledSpoutputs.add(Direction.valueOf((String)((StringTag)d).m_7916_())));
        this.spoutputBuffer = NBTHelper.readItemList((ListTag)compound.m_128437_("Overflow", 10));
        this.spoutputFluidBuffer = NBTHelper.readCompoundList((ListTag)compound.m_128437_("FluidOverflow", 10), FluidStack::loadFluidStackFromNBT);
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedItems", 10), c -> this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.with((int)10, (Object)ItemStack.m_41712_((CompoundTag)c))));
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.with((int)10, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)c))));
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
        if (this.preferredSpoutput != null) {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"PreferredSpoutput", (Enum)this.preferredSpoutput);
        }
        ListTag disabledList = new ListTag();
        this.disabledSpoutputs.forEach(d -> disabledList.add((Object)StringTag.m_129297_((String)d.name())));
        compound.m_128365_("DisabledSpoutput", (Tag)disabledList);
        compound.m_128365_("Overflow", (Tag)NBTHelper.writeItemList(this.spoutputBuffer));
        compound.m_128365_("FluidOverflow", (Tag)NBTHelper.writeCompoundList(this.spoutputFluidBuffer, fs -> fs.writeToNBT(new CompoundTag())));
        if (!clientPacket) {
            return;
        }
        compound.m_128365_("VisualizedItems", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> ((ItemStack)ia.getValue()).serializeNBT()));
        compound.m_128365_("VisualizedFluids", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new CompoundTag())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInventory);
        this.spoutputBuffer.forEach(is -> Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)is));
    }

    @Override
    public boolean isEmpty() {
        return this.inputInventory.m_7983_() && this.outputInventory.m_7983_() && this.inputTank.isEmpty() && this.outputTank.isEmpty();
    }

    public boolean isBufferEmpty() {
        return this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty();
    }

    public void onWrenched(Direction face) {
        BlockState blockState = this.m_58900_();
        Direction currentFacing = (Direction)blockState.m_61143_((Property)ChamberBottomBlock.FACING);
        this.disabledSpoutputs.remove(face);
        if (currentFacing == face) {
            if (this.preferredSpoutput == face) {
                this.preferredSpoutput = null;
            }
            this.disabledSpoutputs.add(face);
        } else {
            this.preferredSpoutput = face;
        }
        this.updateSpoutput();
    }

    @Override
    public void lazyTick() {
        if (!this.f_58857_.f_46443_) {
            this.updateSpoutput();
        }
        super.lazyTick();
    }

    private void updateSpoutput() {
        BlockState blockState = this.m_58900_();
        Direction currentFacing = (Direction)blockState.m_61143_((Property)ChamberBottomBlock.FACING);
        Direction newFacing = Direction.DOWN;
        for (Direction test : Iterate.horizontalDirections) {
            boolean canOutputTo = BasinBlock.canOutputTo((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_, (Direction)test);
            if (!canOutputTo || this.disabledSpoutputs.contains(test)) continue;
            newFacing = test;
        }
        if (this.preferredSpoutput != null && BasinBlock.canOutputTo((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_, (Direction)this.preferredSpoutput) && this.preferredSpoutput != Direction.UP) {
            newFacing = this.preferredSpoutput;
        }
        if (newFacing == currentFacing) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)ChamberBottomBlock.FACING, (Comparable)newFacing));
        if (newFacing.m_122434_().m_122478_()) {
            return;
        }
        for (int slot = 0; slot < this.outputInventory.getSlots(); ++slot) {
            ItemStack extractItem = this.outputInventory.extractItem(slot, 64, true);
            if (extractItem.m_41619_() || !this.acceptOutputs((List<ItemStack>)ImmutableList.of((Object)extractItem), Collections.emptyList(), true)) continue;
            this.acceptOutputs((List<ItemStack>)ImmutableList.of((Object)this.outputInventory.extractItem(slot, 64, false)), Collections.emptyList(), false);
        }
        IFluidHandler handler = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        for (int slot = 0; slot < handler.getTanks(); ++slot) {
            FluidStack fs = handler.getFluidInTank(slot).copy();
            if (fs.isEmpty() || !this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), true)) continue;
            handler.drain(fs, IFluidHandler.FluidAction.EXECUTE);
            this.acceptOutputs(Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fs), false);
        }
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.createFluidParticles();
            this.tickVisualizedOutputs();
        }
        if (!(this.spoutputBuffer.isEmpty() && this.spoutputFluidBuffer.isEmpty() || this.f_58857_.f_46443_)) {
            this.tryClearingSpoutputOverflow();
        }
        this.scheduleChangeOfContents();
    }

    private void tryClearingSpoutputOverflow() {
        BlockState blockState = this.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)ChamberBottomBlock.FACING);
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
        FilteringBehaviour filter = null;
        InvManipulationBehaviour inserter = null;
        if (be != null) {
            filter = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)FilteringBehaviour.TYPE);
            inserter = (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
        }
        if (filter != null && filter.isRecipeFilter()) {
            filter = null;
        }
        IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
        IFluidHandler targetTank = be == null ? null : (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse(null);
        boolean update = false;
        Iterator<ItemStack> iterator = this.spoutputBuffer.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (direction == Direction.DOWN) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)itemStack);
                iterator.remove();
                update = true;
                continue;
            }
            if (targetInv == null) break;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack, (boolean)true);
            if (remainder.m_41613_() == itemStack.m_41613_() || filter != null && !filter.test(itemStack)) continue;
            if (this.visualizedOutputItems.size() < 3) {
                this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.withZero((Object)itemStack));
            }
            update = true;
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)false);
            if (remainder.m_41619_()) {
                iterator.remove();
                continue;
            }
            itemStack.m_41764_(remainder.m_41613_());
        }
        iterator = this.spoutputFluidBuffer.iterator();
        block1: while (iterator.hasNext()) {
            FluidStack fluidStack = (FluidStack)iterator.next();
            if (direction == Direction.DOWN) {
                iterator.remove();
                update = true;
                continue;
            }
            if (targetTank == null) break;
            for (boolean simulate : Iterate.trueAndFalse) {
                IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
                int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
                if (fill != fluidStack.getAmount()) continue block1;
                if (simulate) continue;
                update = true;
                iterator.remove();
                if (this.visualizedOutputFluids.size() >= 3) continue;
                this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.withZero((Object)fluidStack));
            }
        }
        if (update) {
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    @Override
    public Optional<ChamberOperatingBlockEntity> getOperator() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_6630_(4));
        if (be instanceof ChamberOperatingBlockEntity) {
            ChamberOperatingBlockEntity operator = (ChamberOperatingBlockEntity)be;
            return Optional.of(operator);
        }
        return Optional.empty();
    }

    public SmartInventory getOutputInventory() {
        return this.outputInventory;
    }

    @Override
    public IItemHandlerModifiable getInvs() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory});
    }

    @Override
    public IFluidHandler getTanks() {
        LazyOptional inputCap = this.inputTank.getCapability();
        LazyOptional outputCap = this.outputTank.getCapability();
        return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null)});
    }

    @Override
    public ChamberTopBlockEntity getTop() {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_6630_(2));
        if (be instanceof ChamberTopBlockEntity) {
            ChamberTopBlockEntity top = (ChamberTopBlockEntity)be;
            return top;
        }
        return null;
    }

    @Override
    public ChamberMiddleBlockEntity getMiddle() {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_6630_(1));
        if (be instanceof ChamberMiddleBlockEntity) {
            ChamberMiddleBlockEntity middle = (ChamberMiddleBlockEntity)be;
            return middle;
        }
        return null;
    }

    @Override
    public ChamberBottomBlockEntity getBottom() {
        return this;
    }

    @Override
    protected NonNullList<Ingredient> ingredients(Recipe<?> recipe) {
        if (recipe instanceof ChamberRecipe) {
            ChamberRecipe chamberRecipe = (ChamberRecipe)recipe;
            return chamberRecipe.bottomIngredients;
        }
        return NonNullList.m_122779_();
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)ChamberBottomBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            InvManipulationBehaviour inserter;
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
            InvManipulationBehaviour invManipulationBehaviour = inserter = be == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
            IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
            IFluidHandler targetTank = be == null ? null : (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse(null);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoChamber(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
            for (ItemStack itemStack : outputItems) {
                if (itemStack.m_41619_()) continue;
                this.spoutputBuffer.add(itemStack.m_41777_());
            }
            if (!externalTankNotPresent) {
                for (FluidStack fluidStack : outputFluids) {
                    this.spoutputFluidBuffer.add(fluidStack.copy());
                }
            }
            return true;
        }
        SmartInventory targetInv = this.outputInventory;
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoChamber(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoChamber(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoChamber(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoChamber(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected InteractionResult use(Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack heldItem = player.m_21120_(handIn);
        SmartInventory inv = this.getOutputInventory();
        if (heldItem.m_41619_() && !inv.m_7983_() && this.emptyInv(inv, player)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
            return InteractionResult.SUCCESS;
        }
        return super.use(worldIn, pos, player, handIn);
    }

    private void tickVisualizedOutputs() {
        this.visualizedOutputFluids.forEach(IntAttached::decrement);
        this.visualizedOutputItems.forEach(IntAttached::decrement);
        this.visualizedOutputFluids.removeIf(IntAttached::isOrBelowZero);
        this.visualizedOutputItems.removeIf(IntAttached::isOrBelowZero);
    }

    private void createFluidParticles() {
        RandomSource r = this.f_58857_.f_46441_;
        BlockState blockState = this.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)ChamberBottomBlock.FACING);
        if (direction == Direction.DOWN) {
            return;
        }
        Vec3 directionVec = Vec3.m_82528_((Vec3i)direction.m_122436_());
        Vec3 outVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(directionVec.m_82490_(0.65).m_82492_(0.0, 0.25, 0.0));
        Vec3 outMotion = directionVec.m_82490_(0.0625).m_82520_(0.0, -0.0625, 0.0);
        for (int i = 0; i < 2; ++i) {
            this.visualizedOutputFluids.forEach(ia -> {
                FluidStack fluidStack = (FluidStack)ia.getValue();
                ParticleOptions fluidParticle = FluidFX.getFluidParticle((FluidStack)fluidStack);
                Vec3 m = VecHelper.offsetRandomly((Vec3)outMotion, (RandomSource)r, (float)0.0625f);
                this.f_58857_.m_7107_(fluidParticle, outVec.f_82479_, outVec.f_82480_, outVec.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
            });
        }
    }

    class ChamberValueBox
    extends ValueBoxTransform.Sided {
        ChamberValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

