/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.sculkcatalyticchamber.content.chamber;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberBottomBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberMiddleBlockEntity;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberRecipeBuilder;
import net.dragonegg.sculkcatalyticchamber.content.chamber.ChamberTopBlockEntity;
import net.dragonegg.sculkcatalyticchamber.registry.RecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ChamberRecipe
implements Recipe<SmartInventory> {
    private static final Random r = new Random();
    protected ResourceLocation id;
    protected NonNullList<Ingredient> topIngredients;
    protected NonNullList<FluidIngredient> topFluidIngredients;
    protected NonNullList<Ingredient> bottomIngredients;
    protected NonNullList<FluidIngredient> bottomFluidIngredients;
    protected NonNullList<Ingredient> catalysts;
    protected NonNullList<FluidIngredient> fluidCatalysts;
    protected double chances;
    protected NonNullList<ProcessingOutput> results;
    protected NonNullList<FluidStack> fluidResults;
    protected HeatCondition requiredHeat;
    private RecipeType<?> type;
    private RecipeSerializer<?> serializer;
    private IRecipeTypeInfo typeInfo;
    private Supplier<ItemStack> forcedResult;

    protected ChamberRecipe(IRecipeTypeInfo typeInfo, ChamberRecipeBuilder.ChamberRecipeParams params) {
        this.id = params.id;
        this.topIngredients = params.topIngredients;
        this.topFluidIngredients = params.topFluidIngredients;
        this.bottomIngredients = params.bottomIngredients;
        this.bottomFluidIngredients = params.bottomFluidIngredients;
        this.catalysts = params.catalysts;
        this.fluidCatalysts = params.fluidCatalysts;
        this.chances = params.chances;
        this.results = params.results;
        this.fluidResults = params.fluidResults;
        this.requiredHeat = params.requiredHeat;
        this.type = typeInfo.getType();
        this.serializer = typeInfo.getSerializer();
        this.typeInfo = typeInfo;
        this.forcedResult = null;
    }

    public ChamberRecipe(ChamberRecipeBuilder.ChamberRecipeParams params) {
        this(RecipeRegistry.CHAMBER, params);
    }

    public NonNullList<Ingredient> getTopIngredients() {
        return this.topIngredients;
    }

    public NonNullList<Ingredient> getCatalysts() {
        return this.catalysts;
    }

    public NonNullList<Ingredient> getBottomIngredients() {
        return this.bottomIngredients;
    }

    public NonNullList<FluidIngredient> getTopFluidIngredients() {
        return this.topFluidIngredients;
    }

    public NonNullList<FluidIngredient> getFluidCatalysts() {
        return this.fluidCatalysts;
    }

    public NonNullList<FluidIngredient> getBottomFluidIngredients() {
        return this.bottomFluidIngredients;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll(this.topIngredients);
        ingredients.addAll(this.bottomIngredients);
        return ingredients;
    }

    public NonNullList<FluidIngredient> getFluidIngredients() {
        NonNullList fluidIngredients = NonNullList.m_122779_();
        fluidIngredients.addAll(this.topFluidIngredients);
        fluidIngredients.addAll(this.bottomFluidIngredients);
        return fluidIngredients;
    }

    public List<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public NonNullList<FluidStack> getFluidResults() {
        return this.fluidResults;
    }

    public List<ItemStack> getRollableResultsAsItemStacks() {
        return this.getRollableResults().stream().map(ProcessingOutput::getStack).collect(Collectors.toList());
    }

    public void enforceNextResult(Supplier<ItemStack> stack) {
        this.forcedResult = stack;
    }

    public List<ItemStack> rollResults() {
        return this.rollResults(this.getRollableResults());
    }

    public List<ItemStack> rollResults(List<ProcessingOutput> rollableResults) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ItemStack stack;
            ProcessingOutput output = rollableResults.get(i);
            ItemStack itemStack = stack = i == 0 && this.forcedResult != null ? this.forcedResult.get() : output.rollOutput();
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    public double getChance() {
        return this.chances;
    }

    public HeatCondition getRequiredHeat() {
        return this.requiredHeat;
    }

    public static boolean match(ChamberBlockEntity chamber, Recipe<?> recipe) {
        if (!(recipe instanceof ChamberRecipe)) {
            return false;
        }
        ChamberRecipe chamberRecipe = (ChamberRecipe)recipe;
        FilteringBehaviour filter = chamber.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(chamber.m_58904_().m_9598_()));
        if (chamberRecipe.getRollableResults().isEmpty() && !chamberRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)chamberRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return ChamberRecipe.apply(chamber, recipe, true);
    }

    public static boolean apply(ChamberBlockEntity chamber, Recipe<?> recipe) {
        return ChamberRecipe.apply(chamber, recipe, false);
    }

    private static boolean apply(ChamberBlockEntity chamber, Recipe<?> recipe, boolean test) {
        if (!(recipe instanceof ChamberRecipe)) {
            return false;
        }
        ChamberRecipe chamberRecipe = (ChamberRecipe)recipe;
        ChamberTopBlockEntity topBE = chamber.getTop();
        ChamberMiddleBlockEntity middleBE = chamber.getMiddle();
        ChamberBottomBlockEntity bottomBE = chamber.getBottom();
        if (topBE == null || middleBE == null || bottomBE == null) {
            return false;
        }
        IItemHandler availableItemsTop = (IItemHandler)topBE.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluidsTop = (IFluidHandler)topBE.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        IItemHandler availableItemsMiddle = (IItemHandler)middleBE.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluidsMiddle = (IFluidHandler)middleBE.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        IItemHandler availableItemsBottom = (IItemHandler)bottomBE.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluidsBottom = (IFluidHandler)bottomBE.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItemsTop == null || availableFluidsTop == null || availableItemsMiddle == null || availableFluidsMiddle == null || availableItemsBottom == null || availableFluidsBottom == null) {
            return false;
        }
        boolean catalystConsumed = r.nextDouble() < chamberRecipe.getChance();
        BlazeBurnerBlock.HeatLevel heat = BlazeBurnerBlock.getHeatLevelOf((BlockState)chamber.m_58904_().m_8055_(bottomBE.m_58899_().m_6625_(1)));
        if (!chamberRecipe.getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        for (boolean simulate : Iterate.trueAndFalse) {
            int drainedAmount;
            FluidStack fluidStack;
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsTop = new int[availableItemsTop.getSlots()];
            int[] extractedFluidsTop = new int[availableFluidsTop.getTanks()];
            int[] extractedItemsMiddle = new int[availableItemsMiddle.getSlots()];
            int[] extractedFluidsMiddle = new int[availableFluidsMiddle.getTanks()];
            int[] extractedItemsBottom = new int[availableItemsBottom.getSlots()];
            int[] extractedFluidsBottom = new int[availableFluidsBottom.getTanks()];
            block1: for (Ingredient ingredient : chamberRecipe.topIngredients) {
                for (int slot = 0; slot < availableItemsTop.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItemsTop.getStackInSlot(slot).m_41613_() <= extractedItemsTop[slot] || !ingredient.test(extracted = availableItemsTop.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItemsTop.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsTop[n] = extractedItemsTop[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            block3: for (FluidIngredient fluidIngredient : chamberRecipe.topFluidIngredients) {
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluidsTop.getTanks(); ++tank) {
                    fluidStack = availableFluidsTop.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsTop[tank] || !fluidIngredient.test(fluidStack)) continue;
                    drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsTop[n] = extractedFluidsTop[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)topBE.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            block5: for (Ingredient ingredient : chamberRecipe.catalysts) {
                for (int slot = 0; slot < availableItemsMiddle.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItemsMiddle.getStackInSlot(slot).m_41613_() <= extractedItemsMiddle[slot] || !ingredient.test(extracted = availableItemsMiddle.extractItem(slot, 1, true))) continue;
                    if (!simulate && catalystConsumed) {
                        availableItemsMiddle.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsMiddle[n] = extractedItemsMiddle[n] + 1;
                    continue block5;
                }
                return false;
            }
            fluidsAffected = false;
            block7: for (FluidIngredient fluidIngredient : chamberRecipe.fluidCatalysts) {
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluidsMiddle.getTanks(); ++tank) {
                    fluidStack = availableFluidsMiddle.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsMiddle[tank] || !fluidIngredient.test(fluidStack)) continue;
                    drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate && catalystConsumed) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsMiddle[n] = extractedFluidsMiddle[n] + drainedAmount;
                    continue block7;
                }
                return false;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)middleBE.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            block9: for (Ingredient ingredient : chamberRecipe.bottomIngredients) {
                for (int slot = 0; slot < availableItemsBottom.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItemsBottom.getStackInSlot(slot).m_41613_() <= extractedItemsBottom[slot] || !ingredient.test(extracted = availableItemsBottom.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItemsBottom.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsBottom[n] = extractedItemsBottom[n] + 1;
                    continue block9;
                }
                return false;
            }
            fluidsAffected = false;
            block11: for (FluidIngredient fluidIngredient : chamberRecipe.bottomFluidIngredients) {
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluidsBottom.getTanks(); ++tank) {
                    fluidStack = availableFluidsBottom.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsBottom[tank] || !fluidIngredient.test(fluidStack)) continue;
                    drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsBottom[n] = extractedFluidsBottom[n] + drainedAmount;
                    continue block11;
                }
                return false;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)bottomBE.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)bottomBE.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate) {
                recipeOutputItems.addAll(chamberRecipe.rollResults());
                for (FluidStack fluidStack2 : chamberRecipe.getFluidResults()) {
                    if (fluidStack2.isEmpty()) continue;
                    recipeOutputFluids.add(fluidStack2);
                }
                for (ItemStack stack : chamberRecipe.getRemainingItems(topBE.getInputInventory(), extractedItemsTop)) {
                    if (stack.m_41619_()) continue;
                    recipeOutputItems.add(stack);
                }
                if (catalystConsumed) {
                    for (ItemStack stack : chamberRecipe.getRemainingItems(middleBE.getInputInventory(), extractedItemsMiddle)) {
                        if (stack.m_41619_()) continue;
                        recipeOutputItems.add(stack);
                    }
                }
                for (ItemStack stack : chamberRecipe.getRemainingItems(bottomBE.getInputInventory(), extractedItemsBottom)) {
                    if (stack.m_41619_()) continue;
                    recipeOutputItems.add(stack);
                }
            }
            if (bottomBE.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        return false;
    }

    public ItemStack assemble(SmartInventory pContainer, RegistryAccess pRegistryAccess) {
        return this.m_8043_(pRegistryAccess);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.getRollableResults().isEmpty() ? ItemStack.f_41583_ : this.getRollableResults().get(0).getStack();
    }

    public NonNullList<ItemStack> getRemainingItems(SmartInventory container, int[] extracted) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (!item.hasCraftingRemainingItem()) continue;
            nonnulllist.set(i, (Object)item.getCraftingRemainingItem().m_255036_(extracted[i]));
        }
        return nonnulllist;
    }

    public boolean m_5598_() {
        return true;
    }

    public String m_6076_() {
        return "chamber";
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public IRecipeTypeInfo getTypeInfo() {
        return this.typeInfo;
    }
}

