/*
 * Decompiled with CFR 0.152.
 */
package de.jannik.createrailwaysignal.compat;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class PantographsCompat {
    public static final String MODID = "pantographsandwires";
    private static final List<class_2960> SUPPORT_IDS = List.of(PantographsCompat.id("lattice_mast"), PantographsCompat.id("steel_mast"), PantographsCompat.id("wood_mast"), PantographsCompat.id("power_line_bracket"), PantographsCompat.id("cantilever_bracket"));

    private PantographsCompat() {
    }

    private static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }

    public static boolean isLoaded() {
        return FabricLoader.getInstance().isModLoaded(MODID);
    }

    public static boolean isSupport(class_2680 state) {
        if (!PantographsCompat.isLoaded()) {
            return false;
        }
        class_2248 b = state.method_26204();
        for (class_2960 ident : SUPPORT_IDS) {
            Optional reg = class_7923.field_41175.method_17966(ident);
            if (!reg.isPresent() || !state.method_27852((class_2248)reg.get())) continue;
            return true;
        }
        return false;
    }

    public static Optional<Float> getYRotation(class_2680 state) {
        if (!PantographsCompat.isLoaded()) {
            return Optional.empty();
        }
        try {
            Class<?> iface = Class.forName("de.mrjulsen.paw.block.abstractions.IRotatableBlock");
            class_2248 block = state.method_26204();
            if (!iface.isInstance(block)) {
                return Optional.empty();
            }
            Method m = Arrays.stream(iface.getMethods()).filter(me -> me.getName().equals("getYRotation") && me.getParameterCount() == 1).findFirst().orElse(null);
            if (m == null) {
                m = Arrays.stream(iface.getMethods()).filter(me -> me.getName().equals("getRelativeYRotation") && me.getParameterCount() == 1).findFirst().orElse(null);
            }
            if (m == null) {
                return Optional.empty();
            }
            Object val = m.invoke((Object)block, state);
            if (val instanceof Number) {
                Number n = (Number)val;
                return Optional.of(Float.valueOf(n.floatValue()));
            }
            return Optional.empty();
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static boolean hasSupportBehindConsideringRotation(class_1937 world, class_2338 pos, class_2350 facing) {
        class_2350 back = facing.method_10153();
        if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back)))) {
            return true;
        }
        class_2350 left = facing.method_10160();
        class_2350 right = facing.method_10170();
        class_2680 backState = world.method_8320(pos.method_10093(back));
        Optional<Float> deg = PantographsCompat.getYRotation(backState);
        if (deg.isPresent()) {
            float a = PantographsCompat.normalize(deg.get().floatValue());
            if (PantographsCompat.isDiagBucket(a)) {
                if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back).method_10093(left)))) {
                    return true;
                }
                if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back).method_10093(right)))) {
                    return true;
                }
            }
            if (PantographsCompat.isStrongDiagBucket(a)) {
                if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back).method_10093(left).method_10093(back)))) {
                    return true;
                }
                if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back).method_10093(right).method_10093(back)))) {
                    return true;
                }
            }
        } else {
            if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back).method_10093(left)))) {
                return true;
            }
            if (PantographsCompat.isSupport(world.method_8320(pos.method_10093(back).method_10093(right)))) {
                return true;
            }
        }
        return false;
    }

    private static float normalize(float deg) {
        if ((deg %= 360.0f) < 0.0f) {
            deg += 360.0f;
        }
        return deg;
    }

    private static boolean in(float x, float lo, float hi) {
        return x >= lo && x <= hi;
    }

    private static boolean isDiagBucket(float a) {
        return PantographsCompat.in(a, 10.0f, 35.0f) || PantographsCompat.in(a, 155.0f, 200.0f) || PantographsCompat.in(a, 345.0f, 360.0f) || PantographsCompat.in(a, 0.0f, 15.0f);
    }

    private static boolean isStrongDiagBucket(float a) {
        return PantographsCompat.in(a, 35.0f, 55.0f) || PantographsCompat.in(a, 125.0f, 145.0f) || PantographsCompat.in(a, 215.0f, 235.0f) || PantographsCompat.in(a, 305.0f, 325.0f);
    }
}

